/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler.asyncprofiler;

import com.google.common.collect.ImmutableSet;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Enumeration;
import java.util.Set;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.gradle.profiler.Logging;
import org.gradle.profiler.OperatingSystem;

public class AsyncProfilerDownload {
    private static final String ASYNC_PROFILER_VERSION = "4.2";

    static File defaultHome() {
        String extension;
        String platformName;
        if (OperatingSystem.isMacOS()) {
            platformName = "macos";
            extension = "zip";
        } else if (OperatingSystem.isLinuxAarch64()) {
            platformName = "linux-arm64";
            extension = "tar.gz";
        } else if (OperatingSystem.isLinuxX86()) {
            platformName = "linux-x64";
            extension = "tar.gz";
        } else {
            return null;
        }
        Path installDist = Paths.get(System.getProperty("user.home"), ".gradle-profiler-dist", "4.2-" + platformName);
        Path marker = installDist.resolve("ok");
        Path homeDir = installDist.resolve(String.format("async-profiler-%s-%s", ASYNC_PROFILER_VERSION, platformName));
        if (Files.isReadable(marker)) {
            return homeDir.toFile();
        }
        try {
            URL download = new URL(String.format("https://github.com/async-profiler/async-profiler/releases/download/v%1$s/async-profiler-%1$s-%2$s.%3$s", ASYNC_PROFILER_VERSION, platformName, extension));
            Logging.startOperation("Download and install " + download);
            Files.createDirectories(installDist, new FileAttribute[0]);
            Path bundle = installDist.resolve(String.format("async-profiler.%s", extension));
            AsyncProfilerDownload.copyTo(download, bundle);
            AsyncProfilerDownload.deleteDir(homeDir);
            if (extension.equals("tar.gz")) {
                AsyncProfilerDownload.untarTo(bundle, installDist);
            } else {
                AsyncProfilerDownload.unzipTo(bundle, installDist);
            }
            Files.createFile(marker, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not install async-profiler", e);
        }
        return homeDir.toFile();
    }

    private static void unzipTo(Path source, Path destDir) throws IOException {
        try (ZipFile zipFile = ((ZipFile.Builder)ZipFile.builder().setPath(source)).get();){
            Enumeration entries = zipFile.getEntries();
            while (entries.hasMoreElements()) {
                ZipArchiveEntry entry = (ZipArchiveEntry)entries.nextElement();
                InputStream entryInputStream = zipFile.getInputStream(entry);
                Throwable throwable = null;
                try {
                    AsyncProfilerDownload.extractEntry(destDir, entryInputStream, (ArchiveEntry)entry);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (entryInputStream == null) continue;
                    if (throwable != null) {
                        try {
                            entryInputStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    entryInputStream.close();
                }
            }
        }
    }

    private static void untarTo(Path source, Path destDir) throws IOException {
        try (BufferedInputStream bis = new BufferedInputStream(Files.newInputStream(source, new OpenOption[0]));
             GzipCompressorInputStream gzipIs = new GzipCompressorInputStream((InputStream)bis);
             TarArchiveInputStream tarStream = new TarArchiveInputStream((InputStream)gzipIs);){
            TarArchiveEntry entry;
            while ((entry = tarStream.getNextEntry()) != null) {
                AsyncProfilerDownload.extractEntry(destDir, (InputStream)tarStream, (ArchiveEntry)entry);
            }
        }
    }

    private static void extractEntry(Path destDir, InputStream inputStream, ArchiveEntry entry) throws IOException {
        if (entry.isDirectory()) {
            return;
        }
        Path file = destDir.resolve(entry.getName()).normalize();
        if (!file.startsWith(destDir)) {
            return;
        }
        Files.createDirectories(file.getParent(), new FileAttribute[0]);
        Files.copy(inputStream, file, StandardCopyOption.REPLACE_EXISTING);
        AsyncProfilerDownload.applyExecutablePermissions(AsyncProfilerDownload.getUnixMode(entry), file);
    }

    private static void applyExecutablePermissions(int mode, Path file) throws IOException {
        if (mode != 0) {
            Set<PosixFilePermission> permissions = Files.getPosixFilePermissions(file, new LinkOption[0]);
            ImmutableSet.Builder withExecute = ImmutableSet.builder();
            withExecute.addAll(permissions);
            if ((mode & 0x40) != 0) {
                withExecute.add((Object)PosixFilePermission.OWNER_EXECUTE);
            }
            if ((mode & 8) != 0) {
                withExecute.add((Object)PosixFilePermission.GROUP_EXECUTE);
            }
            if ((mode & 1) != 0) {
                withExecute.add((Object)PosixFilePermission.OTHERS_EXECUTE);
            }
            Files.setPosixFilePermissions(file, (Set<PosixFilePermission>)withExecute.build());
        }
    }

    private static int getUnixMode(ArchiveEntry entry) {
        if (entry instanceof TarArchiveEntry) {
            return ((TarArchiveEntry)entry).getMode();
        }
        if (entry instanceof ZipArchiveEntry) {
            return ((ZipArchiveEntry)entry).getUnixMode();
        }
        return 0;
    }

    private static void copyTo(URL source, Path dest) throws IOException {
        try (BufferedInputStream inputStream = new BufferedInputStream(source.openConnection().getInputStream());){
            Files.copy(inputStream, dest, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    private static void deleteDir(Path homeDir) throws IOException {
        if (Files.isDirectory(homeDir, new LinkOption[0])) {
            Files.walkFileTree(homeDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }
}

