/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler.asyncprofiler;

import java.io.File;
import java.util.List;
import java.util.Locale;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.ValueConverter;
import org.gradle.profiler.OperatingSystem;
import org.gradle.profiler.Profiler;
import org.gradle.profiler.ProfilerFactory;
import org.gradle.profiler.asyncprofiler.AsyncProfiler;
import org.gradle.profiler.asyncprofiler.AsyncProfilerConfig;
import org.gradle.profiler.asyncprofiler.AsyncProfilerDistribution;
import org.gradle.profiler.asyncprofiler.AsyncProfilerDownload;
import org.gradle.profiler.asyncprofiler.AsyncProfilerOutputType;

public class AsyncProfilerFactory
extends ProfilerFactory {
    static final String ASYNC_PROFILER_HOME = "ASYNC_PROFILER_HOME";
    static final String ASYNC_PROFILER_HOME_OPTION = "async-profiler-home";
    private ArgumentAcceptingOptionSpec<File> profilerHomeOption;
    private ArgumentAcceptingOptionSpec<String> eventOption;
    private ArgumentAcceptingOptionSpec<AsyncProfilerConfig.Counter> counterOption;
    private ArgumentAcceptingOptionSpec<Integer> intervalOption;
    private ArgumentAcceptingOptionSpec<Integer> allocIntervalOption;
    private ArgumentAcceptingOptionSpec<Integer> lockThresholdOption;
    private ArgumentAcceptingOptionSpec<Integer> wallIntervalOption;
    private ArgumentAcceptingOptionSpec<Integer> stackDepthOption;
    private ArgumentAcceptingOptionSpec<Boolean> systemThreadOption;

    @Override
    public String getName() {
        return "async-profiler";
    }

    @Override
    public void addOptions(OptionParser parser) {
        this.profilerHomeOption = parser.accepts(ASYNC_PROFILER_HOME_OPTION, "Async Profiler home directory").availableIf("profile", new String[0]).withRequiredArg().ofType(File.class);
        this.eventOption = parser.accepts("async-profiler-event", "The event to sample, e.g. 'cpu' or 'alloc'.").availableIf("profile", new String[0]).withRequiredArg().defaultsTo((Object)"cpu", (Object[])new String[0]);
        this.counterOption = parser.accepts("async-profiler-counter", "The counter to use, either 'samples' or 'totals'").availableIf("profile", new String[0]).withRequiredArg().withValuesConvertedBy((ValueConverter)new CounterConverter()).defaultsTo((Object)AsyncProfilerConfig.Counter.SAMPLES, (Object[])new AsyncProfilerConfig.Counter[0]);
        this.intervalOption = parser.accepts("async-profiler-interval", "The sampling interval in nanoseconds. Default is 10ms.").availableIf("profile", new String[0]).withRequiredArg().ofType(Integer.class).defaultsTo((Object)10000000, (Object[])new Integer[0]);
        this.allocIntervalOption = parser.accepts("async-profiler-alloc-interval", "The sampling interval in bytes for allocation profiling. Default is 512 KiB.").availableIf("profile", new String[0]).withRequiredArg().ofType(Integer.class).defaultsTo((Object)524287, (Object[])new Integer[0]);
        this.lockThresholdOption = parser.accepts("async-profiler-lock-threshold", "lock profiling threshold in nanoseconds. Default is 250 us.").availableIf("profile", new String[0]).withRequiredArg().ofType(Integer.class).defaultsTo((Object)250000, (Object[])new Integer[0]);
        this.wallIntervalOption = parser.accepts("async-profiler-wall-interval", "wall clock profiling interval in nanoseconds. Default is 10ms.").availableIf("profile", new String[0]).withRequiredArg().ofType(Integer.class).defaultsTo((Object)10000000, (Object[])new Integer[0]);
        this.stackDepthOption = parser.accepts("async-profiler-stackdepth", "The maximum Java stack depth.").availableIf("profile", new String[0]).withRequiredArg().ofType(Integer.class).defaultsTo((Object)2048, (Object[])new Integer[0]);
        this.systemThreadOption = parser.accepts("async-profiler-system-threads", "Whether to show system threads like GC and JIT compiler.").availableIf("profile", new String[0]).withRequiredArg().ofType(Boolean.class).defaultsTo((Object)false, (Object[])new Boolean[0]);
    }

    @Override
    public Profiler createFromOptions(OptionSet parsedOptions) {
        AsyncProfilerConfig config = this.createConfig(parsedOptions);
        return new AsyncProfiler(config);
    }

    AsyncProfilerConfig createConfig(OptionSet parsedOptions) {
        AsyncProfilerDistribution apDistribution = this.getAPDistribution(parsedOptions);
        List events = this.eventOption.values(parsedOptions);
        AsyncProfilerConfig.Counter counter = (AsyncProfilerConfig.Counter)((Object)this.counterOption.value(parsedOptions));
        int interval = (Integer)this.intervalOption.value(parsedOptions);
        int allocInterval = (Integer)this.allocIntervalOption.value(parsedOptions);
        int lockThreshold = (Integer)this.lockThresholdOption.value(parsedOptions);
        int wallInterval = (Integer)this.wallIntervalOption.value(parsedOptions);
        int stackDepth = (Integer)this.stackDepthOption.value(parsedOptions);
        Boolean showSystemThreads = (Boolean)this.systemThreadOption.value(parsedOptions);
        return new AsyncProfilerConfig(apDistribution, events, counter, interval, allocInterval, lockThreshold, wallInterval, stackDepth, showSystemThreads, AsyncProfilerOutputType.STACKS);
    }

    private AsyncProfilerDistribution getAPDistribution(OptionSet parsedOptions) {
        String source;
        File profilerHome = (File)this.profilerHomeOption.value(parsedOptions);
        String string = source = profilerHome != null ? "--async-profiler-home" : null;
        if (profilerHome == null) {
            String homePath = System.getenv(ASYNC_PROFILER_HOME);
            profilerHome = homePath != null ? new File(homePath) : null;
            String string2 = source = homePath != null ? ASYNC_PROFILER_HOME : null;
        }
        if (profilerHome != null && !profilerHome.isDirectory()) {
            throw new IllegalStateException("ASYNC_PROFILER_HOME or --async-profiler-home path is not a directory.");
        }
        if (profilerHome == null) {
            profilerHome = AsyncProfilerDownload.defaultHome();
            source = "DOWNLOAD";
        }
        if (profilerHome == null) {
            throw new IllegalStateException("Async profiler not supported on " + OperatingSystem.getId());
        }
        return new AsyncProfilerDistribution(profilerHome, source);
    }

    private static class CounterConverter
    implements ValueConverter<AsyncProfilerConfig.Counter> {
        private CounterConverter() {
        }

        public AsyncProfilerConfig.Counter convert(String value) {
            return AsyncProfilerConfig.Counter.valueOf(value.toUpperCase(Locale.ROOT));
        }

        public Class<? extends AsyncProfilerConfig.Counter> valueType() {
            return AsyncProfilerConfig.Counter.class;
        }

        public String valuePattern() {
            return null;
        }
    }
}

