/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler.asyncprofiler;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.gradle.profiler.JvmArgsCalculator;
import org.gradle.profiler.ScenarioSettings;
import org.gradle.profiler.asyncprofiler.AsyncProfilerConfig;
import org.gradle.profiler.asyncprofiler.AsyncProfilerOutputType;

class AsyncProfilerJvmArgsCalculator
implements JvmArgsCalculator {
    private final AsyncProfilerConfig profilerConfig;
    private final ScenarioSettings scenarioSettings;
    private final AsyncProfilerOutputType outputType;

    AsyncProfilerJvmArgsCalculator(AsyncProfilerConfig profilerConfig, ScenarioSettings scenarioSettings) {
        this.profilerConfig = profilerConfig;
        this.scenarioSettings = scenarioSettings;
        this.outputType = AsyncProfilerOutputType.from(profilerConfig, scenarioSettings.getScenario());
    }

    @Override
    public void calculateJvmArgs(List<String> jvmArgs) {
        ArrayList<String> events = new ArrayList<String>(this.profilerConfig.getEvents());
        boolean useAllocOption = events.remove("alloc");
        boolean useLockOption = events.remove("lock");
        boolean useWallOption = events.remove("wall");
        int intervalToUse = this.profilerConfig.getInterval();
        StringBuilder agent = new StringBuilder().append("-agentpath:").append(this.profilerConfig.getDistribution().getLibrary()).append("=start");
        if (!events.isEmpty()) {
            agent.append(",event=").append(Joiner.on((String)",").join(events)).append(",interval=").append(intervalToUse);
        }
        agent.append(",jstackdepth=").append(this.profilerConfig.getStackDepth()).append(",").append(this.outputType.getCommandLineOption()).append(",").append(this.profilerConfig.getCounter().name().toLowerCase(Locale.ROOT)).append(",file=").append(this.outputType.individualOutputFileFor(this.scenarioSettings)).append(",ann");
        if (useAllocOption) {
            agent.append(",alloc=").append(this.profilerConfig.getAllocSampleSize());
        }
        if (useLockOption) {
            agent.append(",lock=").append(this.profilerConfig.getLockThreshold());
        }
        if (useWallOption) {
            agent.append(",wall=").append(this.profilerConfig.getWallInterval());
        }
        jvmArgs.add(agent.toString());
    }
}

