/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler.asyncprofiler;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.gradle.profiler.ScenarioDefinition;
import org.gradle.profiler.ScenarioSettings;
import org.gradle.profiler.asyncprofiler.AsyncProfilerConfig;

public enum AsyncProfilerOutputType {
    STACKS("collapsed", ".stacks.txt"),
    JFR("jfr", ".jfr"){

        @Override
        File outputFileFor(ScenarioSettings settings) {
            return settings.computeJfrProfilerOutputLocation();
        }
    }
    ,
    FLAMEGRAPH("flamegraph", ".html");

    private final String commandLineOption;
    protected final String extension;

    public static List<String> allExtensions() {
        return Arrays.stream(AsyncProfilerOutputType.values()).map(it -> it.extension).collect(Collectors.toList());
    }

    public static AsyncProfilerOutputType from(AsyncProfilerConfig config, ScenarioDefinition scenarioDefinition) {
        return config.getEvents().size() > 1 || scenarioDefinition.createsMultipleProcesses() ? JFR : config.getPreferredOutputType();
    }

    private AsyncProfilerOutputType(String commandLineOption, String extension) {
        this.commandLineOption = commandLineOption;
        this.extension = extension;
    }

    File outputFileFor(ScenarioSettings settings) {
        return settings.profilerOutputLocationFor(this.extension);
    }

    File individualOutputFileFor(ScenarioSettings settings) {
        File outputFile = this.outputFileFor(settings);
        return settings.getScenario().createsMultipleProcesses() ? new File(outputFile, "profile-%t-%p.jfr") : outputFile;
    }

    public String getCommandLineOption() {
        return this.commandLineOption;
    }
}

