/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler.chrometrace;

import java.io.File;
import java.util.function.Consumer;
import org.gradle.profiler.GradleArgsCalculator;
import org.gradle.profiler.Profiler;
import org.gradle.profiler.ScenarioSettings;
import org.gradle.profiler.chrometrace.ChromeTraceInstrumentation;

public class ChromeTraceProfiler
extends Profiler {
    public String toString() {
        return "chrome-trace";
    }

    @Override
    public boolean requiresGradle() {
        return true;
    }

    @Override
    public void summarizeResultFile(File resultFile, Consumer<String> consumer) {
        if (resultFile.getName().endsWith("-trace.json")) {
            consumer.accept(resultFile.getAbsolutePath());
        }
    }

    @Override
    public GradleArgsCalculator newGradleArgsCalculator(ScenarioSettings settings) {
        return new ChromeTraceInstrumentation(settings);
    }

    @Override
    public GradleArgsCalculator newInstrumentedBuildsGradleArgsCalculator(ScenarioSettings settings) {
        return gradleArgs -> gradleArgs.add("-Dtrace");
    }
}

