/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler.flamegraph;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.gradle.profiler.flamegraph.DetailLevel;
import org.gradle.profiler.flamegraph.EventType;
import org.gradle.profiler.flamegraph.FlameGraphTool;
import org.gradle.profiler.flamegraph.Stacks;

public class FlameGraphGenerator {
    public static final String FLAME_FILE_SUFFIX = "-flames.svg";
    public static final String ICICLE_FILE_SUFFIX = "-icicles.svg";
    private final FlameGraphTool flameGraphTool = new FlameGraphTool();

    public void generateGraphs(File flameGraphDirectory, List<Stacks> stackFiles) {
        if (!this.flameGraphTool.checkInstallation()) {
            return;
        }
        for (Stacks stacks : stackFiles) {
            this.generateFlameGraph(flameGraphDirectory, stacks);
            this.generateIcicleGraph(flameGraphDirectory, stacks);
        }
    }

    public void generateDifferentialGraphs(List<Stacks> stackFiles) {
        if (!this.flameGraphTool.checkInstallation()) {
            return;
        }
        for (Stacks stacks : stackFiles) {
            this.generateDifferentialFlameGraph(stacks);
            this.generateDifferentialIcicleGraph(stacks);
        }
    }

    private void generateFlameGraph(File flameGraphDirectory, Stacks stacks) {
        if (stacks.isEmpty()) {
            return;
        }
        DetailLevel level = stacks.getLevel();
        EventType type = stacks.getType();
        ArrayList<String> options = new ArrayList<String>();
        options.addAll(level.getFlameGraphOptions());
        options.addAll(Arrays.asList("--title", type.getDisplayName() + " Flame Graph", "--countname", type.getUnitOfMeasure(), "--colors", "java"));
        this.flameGraphTool.generateFlameGraph(stacks.getFile(), new File(flameGraphDirectory, stacks.getFileBaseName() + FLAME_FILE_SUFFIX), options);
    }

    private void generateIcicleGraph(File flameGraphDirectory, Stacks stacks) {
        if (stacks.isEmpty()) {
            return;
        }
        DetailLevel level = stacks.getLevel();
        EventType type = stacks.getType();
        ArrayList<String> options = new ArrayList<String>();
        options.addAll(level.getIcicleGraphOptions());
        options.addAll(Arrays.asList("--title", type.getDisplayName() + " Icicle Graph", "--countname", type.getUnitOfMeasure(), "--reverse", "--invert", "--colors", "java"));
        this.flameGraphTool.generateFlameGraph(stacks.getFile(), new File(flameGraphDirectory, stacks.getFileBaseName() + ICICLE_FILE_SUFFIX), options);
    }

    private void generateDifferentialFlameGraph(Stacks stacks) {
        File stacksFile = stacks.getFile();
        EventType type = stacks.getType();
        DetailLevel level = stacks.getLevel();
        boolean negate = stacks.isNegate();
        File flames = new File(stacksFile.getParentFile(), stacks.getFileBaseName() + FLAME_FILE_SUFFIX);
        ImmutableList.Builder options = ImmutableList.builder();
        options.add((Object[])new String[]{"--title", type.getDisplayName() + (negate ? " Forward " : " Backward Differential Flame Graph")}).add((Object[])new String[]{"--countname", type.getUnitOfMeasure()}).addAll(level.getFlameGraphOptions());
        if (negate) {
            options.add((Object)"--negate");
        }
        this.flameGraphTool.generateFlameGraph(stacksFile, flames, (List<String>)options.build());
    }

    private void generateDifferentialIcicleGraph(Stacks stacks) {
        File stacksFile = stacks.getFile();
        EventType type = stacks.getType();
        DetailLevel level = stacks.getLevel();
        boolean negate = stacks.isNegate();
        File icicles = new File(stacksFile.getParentFile(), stacks.getFileBaseName() + ICICLE_FILE_SUFFIX);
        ImmutableList.Builder options = ImmutableList.builder();
        options.add((Object[])new String[]{"--title", type.getDisplayName() + (negate ? " Forward " : " Backward Differential Icicle Graph")}).add((Object[])new String[]{"--countname", type.getUnitOfMeasure()}).add((Object)"--reverse").add((Object)"--invert").addAll(level.getIcicleGraphOptions());
        if (negate) {
            options.add((Object)"--negate");
        }
        this.flameGraphTool.generateFlameGraph(stacksFile, icicles, (List<String>)options.build());
    }
}

