/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler.flamegraph;

import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FlameGraphSanitizer {
    private static final Splitter STACKTRACE_SPLITTER = Splitter.on((String)";").omitEmptyStrings();
    private static final Joiner STACKTRACE_JOINER = Joiner.on((String)";");
    public static final SanitizeFunction COLLAPSE_BUILD_SCRIPTS = new ReplaceRegex((Map)ImmutableMap.of((Object)Pattern.compile("build_[a-z0-9]+"), (Object)"build script", (Object)Pattern.compile("settings_[a-z0-9]+"), (Object)"settings script"));
    public static final SanitizeFunction COLLAPSE_GRADLE_INFRASTRUCTURE = new CompositeSanitizeFunction(new SanitizeFunction[]{new ChopPrefix("loadSettings"), new ChopPrefix("configureBuild"), new ChopPrefix("constructTaskGraph"), new ChopPrefix("executeTasks"), new ChopPrefix("org.gradle.api.internal.tasks.execution"), new ReplaceContainment(Collections.singletonList("org.gradle.api.internal.tasks.execution"), "task execution_[j]"), new ReplaceContainment(Arrays.asList("DynamicObject", "Closure.call", "MetaClass", "MetaMethod", "CallSite", "ConfigureDelegate", "Method.invoke", "MethodAccessor", "Proxy", "ConfigureUtil", "Script.invoke", "ClosureBackedAction", "getProperty("), "dynamic invocation_[j]"), new ReplaceContainment(Arrays.asList("BuildOperation", "PluginManager", "ObjectConfigurationAction", "PluginTarget", "PluginAware", "Script.apply", "ScriptPlugin", "ScriptTarget", "ScriptRunner", "ProjectEvaluator", "Project.evaluate"), "Gradle infrastructure_[j]")});
    public static final SanitizeFunction SIMPLE_NAMES = new ToSimpleName();
    public static final SanitizeFunction NORMALIZE_LAMBDA_NAMES = new NormalizeLambda();
    private final SanitizeFunction sanitizeFunction;

    public static FlameGraphSanitizer simplified(SanitizeFunction ... additionalSanitizers) {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object[])additionalSanitizers);
        builder.add((Object[])new SanitizeFunction[]{COLLAPSE_BUILD_SCRIPTS, COLLAPSE_GRADLE_INFRASTRUCTURE, SIMPLE_NAMES, NORMALIZE_LAMBDA_NAMES});
        builder.add((Object)new CollapseDuplicateFrames());
        return new FlameGraphSanitizer((ImmutableList<SanitizeFunction>)builder.build());
    }

    public static FlameGraphSanitizer raw(SanitizeFunction ... additionalSanitizers) {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object[])additionalSanitizers);
        builder.add((Object[])new SanitizeFunction[]{COLLAPSE_BUILD_SCRIPTS, NORMALIZE_LAMBDA_NAMES});
        builder.add((Object)new CollapseDuplicateFrames());
        return new FlameGraphSanitizer((ImmutableList<SanitizeFunction>)builder.build());
    }

    public FlameGraphSanitizer(ImmutableList<SanitizeFunction> sanitizeFunctions) {
        this.sanitizeFunction = new CompositeSanitizeFunction((Collection)sanitizeFunctions);
    }

    public void sanitize(File in, File out) {
        out.getParentFile().mkdirs();
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(out));
             BufferedReader reader = Files.newBufferedReader(in.toPath());){
            String line;
            StringBuilder sb = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                int endOfStack = line.lastIndexOf(" ");
                if (endOfStack <= 0) continue;
                String stackTrace = line.substring(0, endOfStack);
                String invocationCount = line.substring(endOfStack + 1);
                List stackTraceElements = STACKTRACE_SPLITTER.splitToList((CharSequence)stackTrace);
                List<String> sanitizedStackElements = this.sanitizeFunction.map(stackTraceElements);
                if (sanitizedStackElements.isEmpty()) continue;
                sb.setLength(0);
                STACKTRACE_JOINER.appendTo(sb, sanitizedStackElements);
                sb.append(" ");
                sb.append(invocationCount);
                sb.append("\n");
                writer.write(sb.toString());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static class ToSimpleName
    extends FrameWiseSanitizeFunction {
        private ToSimpleName() {
        }

        @Override
        protected String mapFrame(String frame) {
            int firstUpper = CharMatcher.javaUpperCase().indexIn((CharSequence)frame);
            return frame.substring(Math.max(firstUpper, 0));
        }
    }

    private static class NormalizeLambda
    extends FrameWiseSanitizeFunction {
        private static final Pattern LAMBDA_PATTERN = Pattern.compile(Pattern.quote("$$Lambda$") + "[0-9]+[./][0-9]+(?:x[0-9a-fA-F]+)?");

        private NormalizeLambda() {
        }

        @Override
        protected String mapFrame(String frame) {
            return LAMBDA_PATTERN.matcher(frame).replaceFirst("\\$\\$Lambda\\$");
        }
    }

    private static class ChopPrefix
    implements SanitizeFunction {
        private final String stopToken;

        private ChopPrefix(String stopToken) {
            this.stopToken = stopToken;
        }

        @Override
        public List<String> map(List<String> stack) {
            for (int i = 0; i < stack.size(); ++i) {
                String frame = stack.get(i);
                if (!frame.contains(this.stopToken)) continue;
                return stack.subList(i, stack.size());
            }
            return stack;
        }
    }

    private static class CollapseDuplicateFrames
    implements SanitizeFunction {
        private CollapseDuplicateFrames() {
        }

        @Override
        public List<String> map(List<String> stack) {
            ArrayList<String> result = new ArrayList<String>(stack);
            ListIterator iterator = result.listIterator();
            String previous = null;
            while (iterator.hasNext()) {
                String next = (String)iterator.next();
                if (next.equals(previous)) {
                    iterator.remove();
                }
                previous = next;
            }
            return result;
        }
    }

    private static class ReplaceRegex
    extends FrameWiseSanitizeFunction {
        private final Map<Pattern, String> replacements;

        private ReplaceRegex(Map<Pattern, String> replacements) {
            this.replacements = replacements;
        }

        @Override
        protected String mapFrame(String frame) {
            for (Map.Entry<Pattern, String> replacement : this.replacements.entrySet()) {
                Matcher matcher = replacement.getKey().matcher(frame);
                String value = replacement.getValue();
                StringBuffer sb = new StringBuffer();
                while (matcher.find()) {
                    matcher.appendReplacement(sb, value);
                }
                matcher.appendTail(sb);
                if (sb.length() <= 0) continue;
                frame = sb.toString();
            }
            return frame;
        }
    }

    private static class ReplaceContainment
    extends FrameWiseSanitizeFunction {
        private final Collection<String> keyWords;
        private final String replacement;

        private ReplaceContainment(Collection<String> keyWords, String replacement) {
            this.keyWords = keyWords;
            this.replacement = replacement;
        }

        @Override
        protected String mapFrame(String frame) {
            for (String keyWord : this.keyWords) {
                if (!frame.contains(keyWord)) continue;
                return this.replacement;
            }
            return frame;
        }
    }

    private static abstract class FrameWiseSanitizeFunction
    implements SanitizeFunction {
        private FrameWiseSanitizeFunction() {
        }

        @Override
        public final List<String> map(List<String> stack) {
            ArrayList<String> result = new ArrayList<String>(stack.size());
            for (String frame : stack) {
                result.add(this.mapFrame(frame));
            }
            return result;
        }

        protected abstract String mapFrame(String var1);
    }

    private static class CompositeSanitizeFunction
    implements SanitizeFunction {
        private final List<SanitizeFunction> sanitizeFunctions;

        private CompositeSanitizeFunction(SanitizeFunction ... sanitizeFunctions) {
            this(Arrays.asList(sanitizeFunctions));
        }

        private CompositeSanitizeFunction(Collection<SanitizeFunction> sanitizeFunctions) {
            this.sanitizeFunctions = ImmutableList.copyOf(sanitizeFunctions);
        }

        @Override
        public List<String> map(List<String> stack) {
            List<String> result = stack;
            for (SanitizeFunction sanitizeFunction : this.sanitizeFunctions) {
                result = sanitizeFunction.map(result);
            }
            return result;
        }
    }

    public static interface SanitizeFunction {
        public List<String> map(List<String> var1);
    }
}

