/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler.maven;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.gradle.profiler.BuildToolCommandLineInvoker;
import org.gradle.profiler.InstrumentingProfiler;
import org.gradle.profiler.InvocationSettings;
import org.gradle.profiler.ScenarioSettings;
import org.gradle.profiler.maven.MavenScenarioDefinition;
import org.gradle.profiler.result.BuildInvocationResult;

public class MavenScenarioInvoker
extends BuildToolCommandLineInvoker<MavenScenarioDefinition, BuildInvocationResult> {
    @Override
    public void run(MavenScenarioDefinition scenario, InvocationSettings settings, Consumer<BuildInvocationResult> resultConsumer) throws IOException, InterruptedException {
        InstrumentingProfiler.SnapshotCapturingProfilerController controller;
        ImmutableMap profileEnvironment;
        ArrayList<String> commandLine = new ArrayList<String>();
        commandLine.add(scenario.getExecutablePath(settings.getProjectDir()));
        commandLine.addAll(scenario.getTargets());
        scenario.getSystemProperties().forEach((key, value) -> commandLine.add(String.format("-D%s=%s", key, value)));
        if (settings.getProfiler() instanceof InstrumentingProfiler) {
            InstrumentingProfiler profiler = (InstrumentingProfiler)settings.getProfiler();
            ScenarioSettings scenarioSettings = new ScenarioSettings(settings, scenario);
            ArrayList<String> mavenOpts = new ArrayList<String>();
            profiler.newInstrumentedBuildsJvmArgsCalculator(scenarioSettings).calculateJvmArgs(mavenOpts);
            profileEnvironment = ImmutableMap.of((Object)"MAVEN_OPTS", (Object)String.join((CharSequence)" ", mavenOpts));
            controller = profiler.newSnapshottingController(scenarioSettings);
        } else {
            profileEnvironment = ImmutableMap.of();
            controller = null;
        }
        this.doRun(scenario, settings, resultConsumer, commandLine, (Map<String, String>)ImmutableMap.of(), (List<String>)ImmutableList.of(), (Map<String, String>)profileEnvironment);
        if (controller != null) {
            controller.stopSession();
        }
    }
}

