/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler.asyncprofiler;

import java.io.File;
import java.util.function.Consumer;
import org.gradle.profiler.InstrumentingProfiler;
import org.gradle.profiler.JvmArgsCalculator;
import org.gradle.profiler.ScenarioSettings;
import org.gradle.profiler.asyncprofiler.AsyncProfilerConfig;
import org.gradle.profiler.asyncprofiler.AsyncProfilerController;
import org.gradle.profiler.asyncprofiler.AsyncProfilerJvmArgsCalculator;
import org.gradle.profiler.asyncprofiler.AsyncProfilerOutputType;

public class AsyncProfiler
extends InstrumentingProfiler {
    private final AsyncProfilerConfig config;

    AsyncProfiler(AsyncProfilerConfig config) {
        this.config = config;
    }

    @Override
    protected JvmArgsCalculator jvmArgsWithInstrumentation(ScenarioSettings settings, boolean startRecordingOnProcessStart, boolean captureSnapshotOnProcessExit) {
        if (!startRecordingOnProcessStart && !captureSnapshotOnProcessExit) {
            return JvmArgsCalculator.DEFAULT;
        }
        return new AsyncProfilerJvmArgsCalculator(this.config, settings);
    }

    @Override
    public InstrumentingProfiler.SnapshotCapturingProfilerController newSnapshottingController(ScenarioSettings settings) {
        return new AsyncProfilerController(this.config, settings);
    }

    @Override
    public void summarizeResultFile(File resultFile, Consumer<String> consumer) {
        AsyncProfilerOutputType.allExtensions().stream().anyMatch(ext -> resultFile.getName().endsWith(".svg"));
        if (resultFile.getName().endsWith(".html") || resultFile.getName().endsWith(".svg")) {
            consumer.accept(resultFile.getAbsolutePath());
        }
    }

    @Override
    public void validate(ScenarioSettings settings, Consumer<String> reporter) {
        this.validateMultipleIterationsWithCleanupAction(settings, reporter);
    }

    @Override
    public boolean isCreatesStacksFiles() {
        return true;
    }

    public String toString() {
        return "async-profiler";
    }
}

