/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler.mutations;

import com.typesafe.config.Config;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.profiler.BuildMutator;
import org.gradle.profiler.CompositeBuildMutator;
import org.gradle.profiler.ConfigUtil;
import org.gradle.profiler.mutations.AbstractFileSystemMutator;
import org.gradle.profiler.mutations.AbstractScheduledMutator;
import org.gradle.profiler.mutations.BuildMutatorConfigurator;

public class ClearDirectoryMutator
extends AbstractFileSystemMutator {
    private final String description;
    private final File target;
    private final List<String> keep;

    public ClearDirectoryMutator(String description, File target, AbstractScheduledMutator.Schedule schedule, List<String> keep) {
        super(schedule);
        this.description = description;
        this.target = target;
        this.keep = keep;
    }

    @Override
    protected void executeOnSchedule() {
        System.out.printf("> Clearing %s: '%s'%n", this.description, this.target.getAbsolutePath());
        if (!this.target.exists()) {
            return;
        }
        if (!this.target.isDirectory()) {
            throw new IllegalArgumentException(String.format("Cannot clear '%s' since it is not a directory", this.target.getAbsolutePath()));
        }
        try (Stream<Path> contents = Files.list(this.target.toPath());){
            contents.filter(path -> !this.keep.contains(path.getFileName().toString())).forEach(path -> ClearDirectoryMutator.deleteFileOrDirectory(path.toFile()));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static class Configurator
    implements BuildMutatorConfigurator {
        @Override
        public BuildMutator configure(String key, BuildMutatorConfigurator.BuildMutatorConfiguratorSpec spec) {
            return CompositeBuildMutator.from(ConfigUtil.configs(spec.getScenario(), key).stream().map(config -> Configurator.createMutator(spec, config)).collect(Collectors.toList()));
        }

        private static ClearDirectoryMutator createMutator(BuildMutatorConfigurator.BuildMutatorConfiguratorSpec spec, Config config) {
            String target = ConfigUtil.string(config, "target");
            AbstractScheduledMutator.Schedule schedule = ConfigUtil.enumValue(config, "schedule", AbstractScheduledMutator.Schedule.class, AbstractScheduledMutator.Schedule.SCENARIO);
            List<String> keep = ConfigUtil.strings(config, "keep");
            AbstractScheduledMutator.FileRoot root = ConfigUtil.enumValue(config, "root", AbstractScheduledMutator.FileRoot.class, AbstractScheduledMutator.FileRoot.PROJECT);
            File projectDir = spec.getProjectDir();
            File gradleUserHome = spec.getGradleUserHome();
            return new ClearDirectoryMutator("directory", AbstractFileSystemMutator.resolveFile(root, projectDir, gradleUserHome, target), schedule, keep);
        }
    }
}

