/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler.mutations;

import com.google.common.base.Strings;
import com.google.common.io.Files;
import com.typesafe.config.Config;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.gradle.profiler.BuildMutator;
import org.gradle.profiler.CompositeBuildMutator;
import org.gradle.profiler.ConfigUtil;
import org.gradle.profiler.mutations.AbstractFileSystemMutator;
import org.gradle.profiler.mutations.AbstractScheduledMutator;
import org.gradle.profiler.mutations.BuildMutatorConfigurator;

public class CopyFileMutator
extends AbstractFileSystemMutator {
    private final File source;
    private final File target;

    public CopyFileMutator(File source, File target, AbstractScheduledMutator.Schedule schedule) {
        super(schedule);
        this.source = source;
        this.target = target;
    }

    @Override
    protected void executeOnSchedule() {
        try {
            System.out.printf("> Copying '%s' to '%s'%n", this.source.getAbsolutePath(), this.target.getAbsolutePath());
            if (!this.target.exists()) {
                Files.createParentDirs((File)this.target);
            }
            if (this.source.isDirectory()) {
                FileUtils.copyDirectory((File)this.source, (File)this.target);
            } else {
                Files.copy((File)this.source, (File)this.target);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to copy '" + this.source.getAbsolutePath() + "' to '" + this.target.getAbsolutePath() + "'", e);
        }
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.source + " - " + this.target + ")";
    }

    public static class Configurator
    implements BuildMutatorConfigurator {
        @Override
        public BuildMutator configure(String key, BuildMutatorConfigurator.BuildMutatorConfiguratorSpec spec) {
            return CompositeBuildMutator.from(ConfigUtil.configs(spec.getScenario(), key).stream().map(config -> Configurator.createMutator(spec, config)).collect(Collectors.toList()));
        }

        private static CopyFileMutator createMutator(BuildMutatorConfigurator.BuildMutatorConfiguratorSpec spec, Config config) {
            String source = ConfigUtil.string(config, "source", null);
            String target = ConfigUtil.string(config, "target", null);
            AbstractScheduledMutator.Schedule schedule = ConfigUtil.enumValue(config, "schedule", AbstractScheduledMutator.Schedule.class, AbstractScheduledMutator.Schedule.SCENARIO);
            AbstractScheduledMutator.FileRoot root = ConfigUtil.enumValue(config, "root", AbstractScheduledMutator.FileRoot.class, AbstractScheduledMutator.FileRoot.PROJECT);
            if (Strings.isNullOrEmpty((String)source) || Strings.isNullOrEmpty((String)target)) {
                throw new IllegalArgumentException("The `source` and `target` are required for copy-file");
            }
            File projectDir = spec.getProjectDir();
            File gradleUserHome = spec.getGradleUserHome();
            return new CopyFileMutator(AbstractFileSystemMutator.resolveFile(root, projectDir, gradleUserHome, source), AbstractFileSystemMutator.resolveFile(root, projectDir, gradleUserHome, target), schedule);
        }
    }
}

