/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler.studio.tools;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.apache.commons.io.FileUtils;

public class StudioPluginInstaller {
    private static final String PLUGIN_INSTALL_FOLDER_NAME = "gradle-profiler-studio-plugin";
    private final Path pluginInstallDir;

    public StudioPluginInstaller(Path studioPluginsDir) {
        this.pluginInstallDir = new File(studioPluginsDir.toFile(), PLUGIN_INSTALL_FOLDER_NAME).toPath();
    }

    public void installPlugin(List<Path> pluginJars) {
        try {
            FileUtils.deleteDirectory((File)this.pluginInstallDir.toFile());
        }
        catch (IOException e) {
            throw new UncheckedIOException("Could not delete previous gradle-profiler plugin installation. This might indicate that another process with gradle-profiler plugin is running in the same sandbox.", e);
        }
        this.installPluginToDirectory(pluginJars);
    }

    private void installPluginToDirectory(List<Path> jars) {
        try {
            for (Path jar : jars) {
                String jarName = jar.getFileName().toString();
                FileUtils.copyFile((File)jar.toFile(), (File)Paths.get(this.pluginInstallDir.toAbsolutePath().toString(), "lib", jarName).toFile());
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void uninstallPlugin() {
        FileUtils.deleteQuietly((File)this.pluginInstallDir.toFile());
    }
}

