/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler.ide.idea;

import com.intellij.ide.starter.community.PublicIdeDownloader;
import com.intellij.ide.starter.ide.IdeArchiveExtractor;
import com.intellij.ide.starter.ide.IdeDownloader;
import com.intellij.ide.starter.ide.installer.IdeInstallerFile;
import com.intellij.ide.starter.models.IdeInfo;
import java.io.File;
import java.nio.file.Path;
import java.util.Collections;
import org.gradle.profiler.ide.IdeProvider;
import org.gradle.profiler.ide.UnpackUtils;
import org.gradle.profiler.ide.idea.IDEA;

public class IDEAProvider
implements IdeProvider<IDEA> {
    private final IdeDownloader ideDownloader = PublicIdeDownloader.INSTANCE;
    private final IdeArchiveExtractor ideArchiveExtractor = IdeArchiveExtractor.INSTANCE;

    @Override
    public File provideIde(IDEA ide, Path homeDir, Path downloadsDir) {
        IdeInfo ideInfo = new IdeInfo("IC", "Idea", "idea", ide.getBuildType(), Collections.emptyList(), "", ide.getVersion(), null, null, "IDEA Community", info -> null);
        String version = ideInfo.getVersion().isEmpty() ? "latest" : ideInfo.getVersion();
        File unpackDir = homeDir.resolve(ideInfo.getInstallerFilePrefix()).resolve(version).toFile();
        File unpackedIde = UnpackUtils.getSingleFileFrom(unpackDir);
        if (unpackedIde != null) {
            System.out.println("Downloading is skipped, get " + ideInfo.getFullName() + " from cache");
            return unpackedIde;
        }
        IdeInstallerFile installerFile = this.ideDownloader.downloadIdeInstaller(ideInfo, downloadsDir);
        this.ideArchiveExtractor.unpackIdeIfNeeded(installerFile.getInstallerFile().toFile(), unpackDir);
        return UnpackUtils.getSingleFileFrom(unpackDir);
    }
}

