/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profiler.ide;

import java.io.File;
import java.nio.file.Path;
import kotlin.io.FilesKt;
import org.gradle.profiler.ide.Ide;
import org.gradle.profiler.ide.IdeProvider;
import org.gradle.profiler.ide.idea.IDEA;
import org.gradle.profiler.ide.idea.IDEAProvider;
import org.gradle.profiler.ide.studio.AndroidStudio;
import org.gradle.profiler.ide.studio.AndroidStudioProvider;

public class DefaultIdeProvider
implements IdeProvider<Ide> {
    private final IDEAProvider ideaProvider = new IDEAProvider();
    private final AndroidStudioProvider studioProvider = new AndroidStudioProvider();

    @Override
    public File provideIde(Ide ide, Path homeDir, Path downloadsDir) {
        File result;
        if (ide instanceof IDEA) {
            result = this.ideaProvider.provideIde((IDEA)ide, homeDir, downloadsDir);
        } else if (ide instanceof AndroidStudio) {
            result = this.studioProvider.provideIde((AndroidStudio)ide, homeDir, downloadsDir);
        } else {
            throw new IllegalArgumentException("Unknown IDE to provide");
        }
        this.cleanup(homeDir, downloadsDir);
        return result;
    }

    private void cleanup(Path homeDir, Path downloadsDir) {
        FilesKt.deleteRecursively((File)downloadsDir.toFile());
    }
}

