/*
 * Decompiled with CFR 0.152.
 */
package org.granite.tide.validation;

import java.util.Map;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import org.granite.messaging.service.ExceptionConverter;
import org.granite.messaging.service.ServiceException;
import org.granite.tide.validation.BeanValidation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanValidationExceptionConverter
implements ExceptionConverter {
    public static final String VALIDATION_FAILED = "Validation.Failed";

    public boolean accepts(Throwable t, Throwable finalException) {
        return t.getClass().equals(ConstraintViolationException.class);
    }

    public ServiceException convert(Throwable t, String detail, Map<String, Object> extendedData) {
        Set constraintViolations = ((ConstraintViolationException)t).getConstraintViolations();
        extendedData.put("invalidValues", BeanValidation.convertConstraintViolations(constraintViolations));
        ServiceException se = new ServiceException(VALIDATION_FAILED, t.getMessage(), detail, t);
        se.getExtendedData().putAll(extendedData);
        return se;
    }
}

