/*
 * Decompiled with CFR 0.152.
 */
package org.granite.tide.validation;

import java.util.Set;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.granite.logging.Logger;
import org.granite.tide.validators.EntityValidator;
import org.granite.tide.validators.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanValidation
implements EntityValidator {
    private static final Logger log = Logger.getLogger(BeanValidation.class);
    private ValidatorFactory validatorFactory = null;

    public BeanValidation() {
        try {
            InitialContext ic = new InitialContext();
            this.validatorFactory = (ValidatorFactory)ic.lookup("java:comp/ValidatorFactory");
        }
        catch (NamingException e) {
            log.info("ValidatorFactory not found in JNDI, build default", new Object[0]);
            this.validatorFactory = Validation.buildDefaultValidatorFactory();
        }
    }

    public BeanValidation(ValidatorFactory validatorFactory) {
        this.validatorFactory = validatorFactory;
    }

    public InvalidValue[] getPotentialInvalidValues(Class<?> entityClass, String propertyName, Object value) {
        Validator validator = this.validatorFactory.getValidator();
        Set constraintViolations = validator.validateValue(entityClass, propertyName, value, new Class[0]);
        return BeanValidation.convertConstraintViolations(constraintViolations);
    }

    public static InvalidValue[] convertConstraintViolations(Set<ConstraintViolation<?>> constraintViolations) {
        InvalidValue[] converted = new InvalidValue[constraintViolations.size()];
        int i = 0;
        for (ConstraintViolation<?> cv : constraintViolations) {
            if (cv.getRootBean() == null) {
                converted[i++] = new InvalidValue(cv.getRootBeanClass(), cv.getPropertyPath().toString(), cv.getInvalidValue(), cv.getMessage());
                continue;
            }
            converted[i++] = new InvalidValue(cv.getRootBean(), cv.getLeafBean() != null ? cv.getLeafBean() : cv.getRootBean(), cv.getPropertyPath().toString(), cv.getInvalidValue(), cv.getMessage());
        }
        return converted;
    }
}

