/*
 * Decompiled with CFR 0.152.
 */
package org.granite.tide.cdi.lazy;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.el.ELResolver;
import javax.enterprise.context.ConversationScoped;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.naming.InitialContext;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.granite.logging.Logger;
import org.granite.tide.TidePersistenceManager;
import org.granite.tide.cdi.PersistenceConfiguration;
import org.granite.tide.data.DataMergeContext;
import org.granite.tide.data.JPAPersistenceManager;

@ConversationScoped
public class CDIInitializer
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(CDIInitializer.class);
    private TidePersistenceManager pm = null;
    private Set<Object> loadedEntities = new HashSet<Object>();
    @Inject
    private BeanManager manager;
    @Inject
    @Any
    private Instance<EntityManager> entityManagers;
    @Inject
    private PersistenceConfiguration persistenceConfiguration;

    public Object lazyInitialize(Object entity, String[] propertyNames) {
        if (entity instanceof String) {
            String expression = "${" + entity + "}";
            ELResolver elResolver = this.manager.getELResolver();
            entity = elResolver.getValue(null, (Object)expression, null);
        }
        if (this.pm == null) {
            this.pm = this.getPersistenceManager();
            if (this.pm == null) {
                throw new RuntimeException("TideInitializer is null, Entities with Lazy relationships have to be retrieved in a conversation");
            }
        }
        return this.pm.attachEntity(entity, propertyNames);
    }

    public TidePersistenceManager getPersistenceManager() {
        try {
            InitialContext ic = new InitialContext();
            if (this.persistenceConfiguration.getEntityManagerFactoryJndiName() != null) {
                EntityManagerFactory emf = (EntityManagerFactory)ic.lookup(this.persistenceConfiguration.getEntityManagerFactoryJndiName());
                return new JPAPersistenceManager(emf);
            }
            if (this.persistenceConfiguration.getEntityManagerJndiName() != null) {
                EntityManager em = (EntityManager)ic.lookup(this.persistenceConfiguration.getEntityManagerJndiName());
                return new JPAPersistenceManager(em);
            }
            if (this.entityManagers != null) {
                EntityManager em;
                Iterator iem = this.entityManagers.iterator();
                EntityManager entityManager = em = iem.hasNext() ? (EntityManager)iem.next() : null;
                if (em == null || iem.hasNext()) {
                    log.error("The application defines zero or more than one Persistence Unit, please define which one should be used for lazy loading in entity-manager-jndi-name", new Object[0]);
                    return null;
                }
                return new JPAPersistenceManager(em);
            }
        }
        catch (Exception e) {
            log.error("Could not get EntityManager", new Object[]{e});
        }
        return null;
    }

    public void restoreLoadedEntities() {
        DataMergeContext.restoreLoadedEntities(this.loadedEntities);
    }

    public void saveLoadedEntities() {
        for (Object entity : DataMergeContext.getLoadedEntities()) {
            this.loadedEntities.add(entity);
        }
    }
}

