/*
 * Decompiled with CFR 0.152.
 */
package org.granite.cdi;

import flex.messaging.messages.Message;
import java.lang.annotation.Annotation;
import javax.enterprise.context.Conversation;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.inject.spi.Bean;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.servlet.http.HttpSession;
import org.granite.context.GraniteContext;
import org.granite.logging.Logger;
import org.granite.messaging.amf.process.AMF3MessageInterceptor;
import org.granite.messaging.service.ServiceException;
import org.granite.messaging.webapp.HttpGraniteContext;
import org.granite.tide.cdi.ConversationState;
import org.granite.tide.cdi.EventState;
import org.granite.tide.cdi.SessionState;
import org.jboss.weld.context.ContextLifecycle;
import org.jboss.weld.context.ConversationContext;
import org.jboss.weld.context.api.BeanStore;
import org.jboss.weld.conversation.ConversationImpl;
import org.jboss.weld.conversation.ConversationManager;
import org.jboss.weld.manager.api.WeldManager;
import org.jboss.weld.servlet.ConversationBeanStore;

public class CDIInterceptor
implements AMF3MessageInterceptor {
    private static final Logger log = Logger.getLogger(CDIInterceptor.class);
    private static final String CONVERSATION_ID = "conversationId";
    private static final String IS_LONG_RUNNING_CONVERSATION = "isLongRunningConversation";
    private static final String WAS_LONG_RUNNING_CONVERSATION_CREATED = "wasLongRunningConversationCreated";
    private static final String WAS_LONG_RUNNING_CONVERSATION_ENDED = "wasLongRunningConversationEnded";

    public static WeldManager lookupBeanManager() {
        HttpGraniteContext context = (HttpGraniteContext)GraniteContext.getCurrentInstance();
        WeldManager manager = (WeldManager)context.getServletContext().getAttribute("javax.enterprise.inject.spi.BeanManager");
        if (manager != null) {
            return manager;
        }
        InitialContext ic = null;
        try {
            ic = new InitialContext();
            return (WeldManager)ic.lookup("java:comp/BeanManager");
        }
        catch (NameNotFoundException e) {
            if (ic == null) {
                throw new RuntimeException("No InitialContext");
            }
            try {
                return (WeldManager)ic.lookup("java:comp/env/BeanManager");
            }
            catch (Exception e1) {
                try {
                    return (WeldManager)ic.lookup("java:app/BeanManager");
                }
                catch (Exception e2) {
                    throw new RuntimeException("Could not find Bean Manager", e2);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not find Bean Manager", e);
        }
    }

    public void before(Message amfReqMessage) {
        if (log.isTraceEnabled()) {
            log.trace("Pre processing of request message: %s", new Object[]{amfReqMessage});
        }
        try {
            GraniteContext context = GraniteContext.getCurrentInstance();
            if (context instanceof HttpGraniteContext) {
                HttpSession session = ((HttpGraniteContext)context).getSession();
                WeldManager beanManager = CDIInterceptor.lookupBeanManager();
                Bean conversationManagerBean = (Bean)beanManager.getBeans(ConversationManager.class, new Annotation[0]).iterator().next();
                ConversationManager conversationManager = (ConversationManager)beanManager.getReference(conversationManagerBean, ConversationManager.class, beanManager.createCreationalContext((Contextual)conversationManagerBean));
                String conversationId = (String)amfReqMessage.getHeader(CONVERSATION_ID);
                conversationManager.beginOrRestoreConversation(conversationId);
                Bean conversationBean = (Bean)beanManager.getBeans(Conversation.class, new Annotation[0]).iterator().next();
                Conversation conversation = (Conversation)beanManager.getReference(conversationBean, Conversation.class, beanManager.createCreationalContext((Contextual)conversationBean));
                String cid = ((ConversationImpl)conversation).getUnderlyingId();
                ConversationContext conversationContext = this.lookupConversationContext(beanManager);
                conversationContext.setBeanStore((BeanStore)new ConversationBeanStore(session, false, cid));
                conversationContext.setActive(true);
                Bean eventBean = (Bean)beanManager.getBeans(EventState.class, new Annotation[0]).iterator().next();
                EventState eventState = (EventState)beanManager.getReference(eventBean, EventState.class, beanManager.createCreationalContext((Contextual)eventBean));
                if (!conversation.isTransient()) {
                    eventState.setWasLongRunning(true);
                }
                if (conversationId != null && conversation.isTransient()) {
                    log.debug("Starting conversation " + conversationId, new Object[0]);
                    conversation.begin(conversationId);
                }
                if (Boolean.TRUE.toString().equals(amfReqMessage.getHeader("org.granite.tide.isFirstCall"))) {
                    Bean ssBean = (Bean)beanManager.getBeans(SessionState.class, new Annotation[0]).iterator().next();
                    ((SessionState)beanManager.getReference(ssBean, SessionState.class, beanManager.createCreationalContext((Contextual)ssBean))).setFirstCall(true);
                }
                if (Boolean.TRUE.toString().equals(amfReqMessage.getHeader("org.granite.tide.isFirstConversationCall")) && !conversation.isTransient()) {
                    Bean csBean = (Bean)beanManager.getBeans(ConversationState.class, new Annotation[0]).iterator().next();
                    ((ConversationState)beanManager.getReference(csBean, ConversationState.class, beanManager.createCreationalContext((Contextual)csBean))).setFirstCall(true);
                }
            }
        }
        catch (Exception e) {
            log.error((Throwable)e, "Exception while pre processing the request message.", new Object[0]);
            throw new ServiceException("Error while pre processing the request message - " + e.getMessage());
        }
    }

    public void after(Message amfReqMessage, Message amfRespMessage) {
        block10: {
            try {
                if (log.isTraceEnabled()) {
                    log.trace("Post processing of response message: %s", new Object[]{amfReqMessage});
                }
                if (!(GraniteContext.getCurrentInstance() instanceof HttpGraniteContext)) break block10;
                WeldManager beanManager = CDIInterceptor.lookupBeanManager();
                try {
                    if (amfRespMessage != null) {
                        Bean conversationBean = (Bean)beanManager.getBeans(Conversation.class, new Annotation[0]).iterator().next();
                        Conversation conversation = (Conversation)beanManager.getReference(conversationBean, Conversation.class, beanManager.createCreationalContext((Contextual)conversationBean));
                        Bean eventBean = (Bean)beanManager.getBeans(EventState.class, new Annotation[0]).iterator().next();
                        EventState eventState = (EventState)beanManager.getReference(eventBean, EventState.class, beanManager.createCreationalContext((Contextual)eventBean));
                        if (eventState.wasLongRunning() && !conversation.isTransient()) {
                            amfRespMessage.setHeader(WAS_LONG_RUNNING_CONVERSATION_ENDED, (Object)true);
                        }
                        if (eventState.wasCreated() && !conversation.isTransient()) {
                            amfRespMessage.setHeader(WAS_LONG_RUNNING_CONVERSATION_CREATED, (Object)true);
                        }
                        amfRespMessage.setHeader(CONVERSATION_ID, (Object)conversation.getId());
                        amfRespMessage.setHeader(IS_LONG_RUNNING_CONVERSATION, (Object)(!conversation.isTransient() ? 1 : 0));
                    }
                }
                finally {
                    ConversationContext conversationContext;
                    if (((HttpGraniteContext)GraniteContext.getCurrentInstance()).getSession(false) != null && (conversationContext = this.lookupConversationContext(beanManager)).isActive()) {
                        Bean conversationManagerBean = (Bean)beanManager.getBeans(ConversationManager.class, new Annotation[0]).iterator().next();
                        ConversationManager conversationManager = (ConversationManager)beanManager.getReference(conversationManagerBean, ConversationManager.class, beanManager.createCreationalContext((Contextual)conversationManagerBean));
                        conversationManager.cleanupConversation();
                    }
                    log.debug("ended request", new Object[0]);
                }
            }
            catch (Exception e) {
                log.error((Throwable)e, "Exception while post processing the response message.", new Object[0]);
                throw new ServiceException("Error while post processing the response message - " + e.getMessage());
            }
        }
    }

    private ConversationContext lookupConversationContext(WeldManager beanManager) {
        return ((ContextLifecycle)beanManager.getServices().get(ContextLifecycle.class)).getConversationContext();
    }
}

