/*
 * Decompiled with CFR 0.152.
 */
package org.granite.tide.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.util.AnnotationLiteral;
import javax.inject.Inject;
import org.granite.messaging.service.annotations.RemoteDestination;
import org.granite.tide.annotations.TideEnabled;
import org.granite.tide.cdi.TideComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TideExtension
implements Extension {
    @Inject
    BeanManager manager;

    public <X> void processAnnotatedType(@Observes ProcessAnnotatedType<X> event) {
        AnnotatedType annotatedType = event.getAnnotatedType();
        boolean tideComponent = false;
        for (Type type : annotatedType.getTypeClosure()) {
            if (!(type instanceof Class) || !((Class)type).isAnnotationPresent(RemoteDestination.class) && !((Class)type).isAnnotationPresent(TideEnabled.class)) continue;
            tideComponent = true;
            break;
        }
        if (tideComponent) {
            event.setAnnotatedType(new TideComponentAnnotatedType(annotatedType));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TideComponentAnnotatedType<T>
    implements AnnotatedType<T> {
        private final AnnotatedType<T> annotatedType;
        private final Annotation componentQualifier = new AnnotationLiteral<TideComponent>(){};
        private final Set<Annotation> annotations;

        public TideComponentAnnotatedType(AnnotatedType<T> annotatedType) {
            this.annotatedType = annotatedType;
            this.annotations = new HashSet<Annotation>(annotatedType.getAnnotations());
            this.annotations.add(this.componentQualifier);
        }

        public Set<AnnotatedConstructor<T>> getConstructors() {
            return this.annotatedType.getConstructors();
        }

        public Set<AnnotatedField<? super T>> getFields() {
            return this.annotatedType.getFields();
        }

        public Class<T> getJavaClass() {
            return this.annotatedType.getJavaClass();
        }

        public Set<AnnotatedMethod<? super T>> getMethods() {
            return this.annotatedType.getMethods();
        }

        public <X extends Annotation> X getAnnotation(Class<X> annotationClass) {
            if (annotationClass.equals(TideComponent.class)) {
                return (X)this.componentQualifier;
            }
            return (X)this.annotatedType.getAnnotation(annotationClass);
        }

        public Set<Annotation> getAnnotations() {
            return this.annotations;
        }

        public Type getBaseType() {
            return this.annotatedType.getBaseType();
        }

        public Set<Type> getTypeClosure() {
            return this.annotatedType.getTypeClosure();
        }

        public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
            if (annotationClass.equals(TideComponent.class)) {
                return true;
            }
            return this.annotatedType.isAnnotationPresent(annotationClass);
        }
    }
}

