/*
 * Decompiled with CFR 0.152.
 */
package org.granite.tide.cdi;

import java.util.ArrayList;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.granite.tide.cdi.CDIServiceContext;
import org.granite.tide.cdi.TideComponent;
import org.granite.tide.cdi.TideInvocation;
import org.granite.tide.invocation.ContextUpdate;

@TideComponent
@Interceptor
public class TideComponentInterceptor {
    @Inject
    private CDIServiceContext tideContext;

    @AroundInvoke
    public Object doAround(InvocationContext invocation) throws Exception {
        TideInvocation tideInvocation = TideInvocation.get();
        if (this.tideContext == null || tideInvocation == null || tideInvocation.isLocked()) {
            return invocation.proceed();
        }
        boolean evaluate = false;
        if (tideInvocation.isEnabled() && !tideInvocation.isUpdated()) {
            ArrayList<ContextUpdate> updates = new ArrayList<ContextUpdate>(tideInvocation.getUpdates());
            tideInvocation.updated();
            this.tideContext.restoreContext(updates, invocation.getTarget());
            evaluate = true;
        }
        Object result = invocation.proceed();
        if (evaluate) {
            tideInvocation.evaluated(this.tideContext.evaluateResults(invocation.getTarget(), false));
        }
        return result;
    }
}

