/*
 * Decompiled with CFR 0.152.
 */
package org.granite.cdi;

import flex.messaging.messages.Message;
import java.lang.annotation.Annotation;
import java.util.Map;
import javax.enterprise.context.Conversation;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestEvent;
import org.granite.cdi.CDIConversationManager;
import org.granite.cdi.CDIUtils;
import org.granite.context.GraniteContext;
import org.granite.logging.Logger;
import org.granite.messaging.amf.process.AMF3MessageInterceptor;
import org.granite.messaging.service.ServiceException;
import org.granite.messaging.webapp.HttpGraniteContext;
import org.granite.messaging.webapp.HttpServletRequestParamWrapper;
import org.granite.tide.cdi.ConversationState;
import org.granite.tide.cdi.EventState;
import org.granite.tide.cdi.SessionState;
import org.granite.util.ClassUtil;
import org.jboss.weld.servlet.WeldListener;

public class CDIInterceptor
implements AMF3MessageInterceptor {
    private static final Logger log = Logger.getLogger(CDIInterceptor.class);
    private static final String CONVERSATION_ID = "conversationId";
    private static final String IS_LONG_RUNNING_CONVERSATION = "isLongRunningConversation";
    private static final String WAS_LONG_RUNNING_CONVERSATION_CREATED = "wasLongRunningConversationCreated";
    private static final String WAS_LONG_RUNNING_CONVERSATION_ENDED = "wasLongRunningConversationEnded";
    private CDIConversationManager conversationManager;
    private WeldListener listener = new WeldListener();
    private static final String MESSAGECOUNT_ATTR = String.valueOf(CDIInterceptor.class.getName()) + "_messageCount";
    private static final String REQUESTWRAPPER_ATTR = String.valueOf(CDIInterceptor.class.getName()) + "_requestWrapper";

    public CDIInterceptor() {
        try {
            Thread.currentThread().getContextClassLoader().loadClass("org.jboss.weld.context.http.HttpConversationContext");
            this.conversationManager = (CDIConversationManager)ClassUtil.newInstance((String)"org.granite.cdi.Weld11ConversationManager", CDIConversationManager.class);
            log.info("Detected Weld 1.1", new Object[0]);
        }
        catch (Exception e) {
            try {
                this.conversationManager = (CDIConversationManager)ClassUtil.newInstance((String)"org.granite.cdi.Weld10ConversationManager", CDIConversationManager.class);
                log.info("Detected Weld 1.0", new Object[0]);
            }
            catch (Exception f) {
                throw new RuntimeException("Could not load conversation manager for CDI implementation", f);
            }
        }
    }

    public void before(Message amf3RequestMessage) {
        if (log.isTraceEnabled()) {
            log.trace("Pre processing of request message: %s", new Object[]{amf3RequestMessage});
        }
        try {
            GraniteContext context = GraniteContext.getCurrentInstance();
            if (context instanceof HttpGraniteContext) {
                HttpGraniteContext httpContext = (HttpGraniteContext)context;
                Integer wrapCount = (Integer)httpContext.getRequest().getAttribute(MESSAGECOUNT_ATTR);
                if (wrapCount == null) {
                    log.debug("Clearing default Weld request context", new Object[0]);
                    ServletRequestEvent event = new ServletRequestEvent(httpContext.getServletContext(), (ServletRequest)httpContext.getRequest());
                    this.listener.requestDestroyed(event);
                    httpContext.getRequest().setAttribute(MESSAGECOUNT_ATTR, (Object)1);
                } else {
                    httpContext.getRequest().setAttribute(MESSAGECOUNT_ATTR, (Object)(wrapCount + 1));
                }
                log.debug("Initializing wrapped AMF request", new Object[0]);
                HttpServletRequestParamWrapper requestWrapper = new HttpServletRequestParamWrapper(httpContext.getRequest());
                httpContext.getRequest().setAttribute(REQUESTWRAPPER_ATTR, (Object)requestWrapper);
                Map headerMap = amf3RequestMessage.getHeaders();
                if (headerMap != null && headerMap.size() > 0) {
                    for (String key : headerMap.keySet()) {
                        String value;
                        String string = value = headerMap.get(key) == null ? null : headerMap.get(key).toString();
                        if (value == null) continue;
                        requestWrapper.setParameter(key, value);
                    }
                }
                ServletRequestEvent event = new ServletRequestEvent(((HttpGraniteContext)context).getServletContext(), (ServletRequest)requestWrapper);
                this.listener.requestInitialized(event);
                String conversationId = (String)amf3RequestMessage.getHeader(CONVERSATION_ID);
                BeanManager beanManager = CDIUtils.lookupBeanManager(((HttpGraniteContext)context).getServletContext());
                Conversation conversation = this.conversationManager.initConversation(beanManager, conversationId);
                Bean eventBean = (Bean)beanManager.getBeans(EventState.class, new Annotation[0]).iterator().next();
                EventState eventState = (EventState)beanManager.getReference(eventBean, EventState.class, beanManager.createCreationalContext((Contextual)eventBean));
                if (!conversation.isTransient()) {
                    eventState.setWasLongRunning(true);
                }
                if (conversationId != null && conversation.isTransient()) {
                    log.debug("Starting conversation " + conversationId, new Object[0]);
                    conversation.begin(conversationId);
                }
                if (Boolean.TRUE.toString().equals(amf3RequestMessage.getHeader("org.granite.tide.isFirstCall"))) {
                    Bean ssBean = (Bean)beanManager.getBeans(SessionState.class, new Annotation[0]).iterator().next();
                    ((SessionState)beanManager.getReference(ssBean, SessionState.class, beanManager.createCreationalContext((Contextual)ssBean))).setFirstCall(true);
                }
                if (Boolean.TRUE.toString().equals(amf3RequestMessage.getHeader("org.granite.tide.isFirstConversationCall")) && !conversation.isTransient()) {
                    Bean csBean = (Bean)beanManager.getBeans(ConversationState.class, new Annotation[0]).iterator().next();
                    ((ConversationState)beanManager.getReference(csBean, ConversationState.class, beanManager.createCreationalContext((Contextual)csBean))).setFirstCall(true);
                }
            }
        }
        catch (Exception e) {
            log.error((Throwable)e, "Exception while pre processing the request message.", new Object[0]);
            throw new ServiceException("Error while pre processing the request message - " + e.getMessage());
        }
    }

    public void after(Message amf3RequestMessage, Message amf3ResponseMessage) {
        block11: {
            try {
                GraniteContext context;
                if (log.isTraceEnabled()) {
                    log.trace("Post processing of response message: %s", new Object[]{amf3ResponseMessage});
                }
                if (!((context = GraniteContext.getCurrentInstance()) instanceof HttpGraniteContext)) break block11;
                BeanManager beanManager = CDIUtils.lookupBeanManager(((HttpGraniteContext)context).getServletContext());
                try {
                    if (amf3ResponseMessage != null) {
                        Bean conversationBean = (Bean)beanManager.getBeans(Conversation.class, new Annotation[0]).iterator().next();
                        Conversation conversation = (Conversation)beanManager.getReference(conversationBean, Conversation.class, beanManager.createCreationalContext((Contextual)conversationBean));
                        Bean eventBean = (Bean)beanManager.getBeans(EventState.class, new Annotation[0]).iterator().next();
                        EventState eventState = (EventState)beanManager.getReference(eventBean, EventState.class, beanManager.createCreationalContext((Contextual)eventBean));
                        if (eventState.wasLongRunning() && !conversation.isTransient()) {
                            amf3ResponseMessage.setHeader(WAS_LONG_RUNNING_CONVERSATION_ENDED, (Object)true);
                        }
                        if (eventState.wasCreated() && !conversation.isTransient()) {
                            amf3ResponseMessage.setHeader(WAS_LONG_RUNNING_CONVERSATION_CREATED, (Object)true);
                        }
                        amf3ResponseMessage.setHeader(CONVERSATION_ID, (Object)conversation.getId());
                        amf3ResponseMessage.setHeader(IS_LONG_RUNNING_CONVERSATION, (Object)(!conversation.isTransient() ? 1 : 0));
                    }
                }
                finally {
                    this.conversationManager.destroyConversation(beanManager);
                    HttpGraniteContext httpContext = (HttpGraniteContext)context;
                    HttpServletRequestParamWrapper requestWrapper = (HttpServletRequestParamWrapper)httpContext.getRequest().getAttribute(REQUESTWRAPPER_ATTR);
                    httpContext.getRequest().removeAttribute(REQUESTWRAPPER_ATTR);
                    ServletRequestEvent event = new ServletRequestEvent(httpContext.getServletContext(), (ServletRequest)requestWrapper);
                    this.listener.requestDestroyed(event);
                    log.debug("Destroying wrapped CDI AMF request", new Object[0]);
                    Integer wrapCount = (Integer)httpContext.getRequest().getAttribute(MESSAGECOUNT_ATTR);
                    if (wrapCount == 1) {
                        log.debug("Restoring default Weld request context", new Object[0]);
                        event = new ServletRequestEvent(((HttpGraniteContext)context).getServletContext(), (ServletRequest)httpContext.getRequest());
                        this.listener.requestInitialized(event);
                        httpContext.getRequest().removeAttribute(MESSAGECOUNT_ATTR);
                    } else {
                        httpContext.getRequest().setAttribute(MESSAGECOUNT_ATTR, (Object)(wrapCount - 1));
                    }
                }
            }
            catch (Exception e) {
                log.error((Throwable)e, "Exception while post processing the response message.", new Object[0]);
                throw new ServiceException("Error while post processing the response message - " + e.getMessage());
            }
        }
    }
}

