/*
 * Decompiled with CFR 0.152.
 */
package org.granite.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import javax.enterprise.context.Conversation;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.servlet.http.HttpSession;
import org.granite.cdi.CDIConversationManager;
import org.granite.context.GraniteContext;
import org.granite.logging.Logger;
import org.granite.messaging.webapp.HttpGraniteContext;
import org.granite.util.ClassUtil;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.manager.api.WeldManager;

public class Weld10ConversationManager
implements CDIConversationManager {
    private static final Logger log = Logger.getLogger(Weld10ConversationManager.class);
    private Class<?> conversationManagerClass;
    private Class<Service> contextLifecycleClass;

    public Weld10ConversationManager() {
        try {
            this.conversationManagerClass = ClassUtil.forName((String)"org.jboss.weld.conversation.ConversationManager");
            this.contextLifecycleClass = ClassUtil.forName((String)"org.jboss.weld.context.ContextLifecycle");
        }
        catch (Exception e) {
            log.error((Throwable)e, "Could not load ConversationManager class", new Object[0]);
        }
    }

    public Conversation initConversation(BeanManager beanManager, String conversationId) {
        try {
            Bean conversationManagerBean = (Bean)beanManager.getBeans(this.conversationManagerClass, new Annotation[0]).iterator().next();
            Object conversationManager = beanManager.getReference(conversationManagerBean, this.conversationManagerClass, beanManager.createCreationalContext((Contextual)conversationManagerBean));
            this.conversationManagerClass.getMethod("beginOrRestoreConversation", String.class).invoke(conversationManager, conversationId);
            Bean conversationBean = (Bean)beanManager.getBeans(Conversation.class, new Annotation[0]).iterator().next();
            Conversation conversation = (Conversation)beanManager.getReference(conversationBean, Conversation.class, beanManager.createCreationalContext((Contextual)conversationBean));
            HttpGraniteContext context = (HttpGraniteContext)GraniteContext.getCurrentInstance();
            String cid = (String)conversation.getClass().getMethod("getUnderlyingId", new Class[0]).invoke((Object)conversation, new Object[0]);
            Object conversationContext = this.lookupConversationContext((WeldManager)beanManager);
            Object beanStore = ClassUtil.newInstance((String)"org.jboss.weld.servlet.ConversationBeanStore", (Class[])new Class[]{HttpSession.class, Boolean.TYPE, String.class}, (Object[])new Object[]{context.getSession(true), false, cid});
            Method[] methodArray = conversationContext.getClass().getMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                Method m = methodArray[n2];
                if ("setBeanStore".equals(m.getName())) {
                    m.invoke(conversationContext, beanStore);
                    break;
                }
                ++n2;
            }
            conversationContext.getClass().getMethod("setActive", Boolean.TYPE).invoke(conversationContext, true);
            return conversation;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not init conversation", e);
        }
    }

    public void destroyConversation(BeanManager beanManager) {
        try {
            Object conversationContext = this.lookupConversationContext((WeldManager)beanManager);
            if (((Boolean)conversationContext.getClass().getMethod("isActive", new Class[0]).invoke(conversationContext, new Object[0])).booleanValue()) {
                Bean conversationManagerBean = (Bean)beanManager.getBeans(this.conversationManagerClass, new Annotation[0]).iterator().next();
                Object conversationManager = beanManager.getReference(conversationManagerBean, this.conversationManagerClass, beanManager.createCreationalContext((Contextual)conversationManagerBean));
                this.conversationManagerClass.getMethod("cleanupConversation", new Class[0]).invoke(conversationManager, new Object[0]);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not destroy conversation", e);
        }
    }

    private Object lookupConversationContext(WeldManager beanManager) throws Exception {
        Service contextLifecycle = beanManager.getServices().get(this.contextLifecycleClass);
        return contextLifecycle.getClass().getMethod("getConversationContext", new Class[0]).invoke((Object)contextLifecycle, new Object[0]);
    }
}

