/*
 * Decompiled with CFR 0.152.
 */
package org.granite.tide.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.ConversationScoped;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.IllegalProductException;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.util.AnnotationLiteral;
import javax.inject.Inject;
import javax.persistence.Entity;
import javax.servlet.http.HttpSession;
import org.granite.config.GraniteConfig;
import org.granite.context.GraniteContext;
import org.granite.logging.Logger;
import org.granite.messaging.amf.io.util.ClassGetter;
import org.granite.messaging.service.ServiceException;
import org.granite.messaging.service.ServiceInvocationContext;
import org.granite.messaging.webapp.HttpGraniteContext;
import org.granite.tide.IInvocationCall;
import org.granite.tide.IInvocationResult;
import org.granite.tide.TidePersistenceManager;
import org.granite.tide.TideServiceContext;
import org.granite.tide.annotations.BypassTideMerge;
import org.granite.tide.async.AsyncPublisher;
import org.granite.tide.cdi.ConversationState;
import org.granite.tide.cdi.ResultsEval;
import org.granite.tide.cdi.ScopedContextResult;
import org.granite.tide.cdi.TideBean;
import org.granite.tide.cdi.TideInstrumentedBeans;
import org.granite.tide.cdi.TideInvocation;
import org.granite.tide.cdi.TideUserEvents;
import org.granite.tide.cdi.UserEvents;
import org.granite.tide.cdi.lazy.CDIInitializer;
import org.granite.tide.data.DataContext;
import org.granite.tide.data.DataUpdatePostprocessor;
import org.granite.tide.invocation.ContextEvent;
import org.granite.tide.invocation.ContextResult;
import org.granite.tide.invocation.ContextUpdate;
import org.granite.tide.invocation.InvocationCall;
import org.granite.tide.invocation.InvocationResult;
import org.granite.util.ClassUtil;
import org.granite.util.Reflections;
import org.jboss.interceptor.util.proxy.TargetInstanceProxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SessionScoped
public class CDIServiceContext
extends TideServiceContext {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(CDIServiceContext.class);
    private static final AnnotationLiteral<Any> ANY_LITERAL = new AnnotationLiteral<Any>(){};
    private static final AnnotationLiteral<Default> DEFAULT_LITERAL = new AnnotationLiteral<Default>(){};
    @Inject
    private BeanManager manager;
    @Inject
    private TideInstrumentedBeans instrumentedBeans;
    private UserEvents userEvents;
    @Inject
    private TideUserEvents tideUserEvents;
    private boolean isAsynchronousContext = true;
    private boolean isFirstCall = false;
    private boolean isLogin = false;
    @Inject
    private CDIInitializer tideEntityInitializer;
    @Inject
    private ResultsEval resultsEval;
    @Inject
    private ConversationState conversation;
    @Inject
    private CDIInitializer initializer;
    private static final Set<Class<?>> KNOWN_IMMUTABLES = new HashSet<Class>(Arrays.asList(String.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Boolean.class, BigInteger.class, BigDecimal.class));

    public void initCall() {
        super.initCall();
        if (this.userEvents != null) {
            return;
        }
        if (this.getSessionId() != null) {
            this.userEvents = this.tideUserEvents.getUserEvents(this.getSessionId());
        } else {
            GraniteContext graniteContext = GraniteContext.getCurrentInstance();
            if (graniteContext instanceof HttpGraniteContext) {
                HttpSession session = ((HttpGraniteContext)graniteContext).getSession(false);
                if (session != null) {
                    this.setSessionId(session.getId());
                }
                this.isAsynchronousContext = false;
            }
        }
    }

    public void setSessionId(String sessionId) {
        super.setSessionId(sessionId);
        this.userEvents = this.tideUserEvents.getUserEvents(sessionId);
    }

    @PreDestroy
    public void endSession() {
        if (!this.isAsynchronousContext && this.getSessionId() != null) {
            this.tideUserEvents.unregisterSession(this.getSessionId());
        }
    }

    public void setLogin(boolean isLogin) {
        this.isLogin = isLogin;
    }

    public Map<ContextResult, Boolean> getResultsEval() {
        return this.resultsEval.getResultsEval();
    }

    public Object findComponent(String componentName, Class<?> componentClass) {
        Bean<?> bean = this.findBean(componentName, componentClass);
        if (bean == null) {
            return null;
        }
        CreationalContext cc = this.manager.createCreationalContext(bean);
        return this.manager.getReference(bean, Object.class, cc);
    }

    public Set<Class<?>> findComponentClasses(String componentName, Class<?> componentClass) {
        Bean<?> bean = this.findBean(componentName, componentClass);
        return this.beanClasses(bean);
    }

    private Bean<?> findBean(String componentName, Class<?> componentClass) {
        Set beans;
        if (componentClass != null && (beans = this.manager.getBeans(componentClass, new Annotation[]{ANY_LITERAL})).size() == 1) {
            return (Bean)beans.iterator().next();
        }
        if (componentName != null && !"".equals(componentName) && !(beans = this.manager.getBeans(componentName)).isEmpty()) {
            return (Bean)beans.iterator().next();
        }
        if (componentClass != null && (beans = this.manager.getBeans(componentClass, new Annotation[]{DEFAULT_LITERAL})).size() == 1) {
            return (Bean)beans.iterator().next();
        }
        return null;
    }

    private Set<Class<?>> beanClasses(Object bean) {
        if (bean instanceof Bean) {
            HashSet classes = new HashSet();
            for (Type type : ((Bean)bean).getTypes()) {
                if (!(type instanceof Class)) continue;
                classes.add((Class)type);
            }
            return classes;
        }
        HashSet classes = new HashSet(1);
        classes.add(bean.getClass());
        return classes;
    }

    public void processEvent(Object event) {
        String sessionId;
        TideInvocation tideInvocation = TideInvocation.get();
        if (tideInvocation == null) {
            return;
        }
        if (this.userEvents != null && (sessionId = this.getSessionId()) != null && this.userEvents.hasEventType(event.getClass())) {
            Object[] objectArray = new Object[2];
            objectArray[0] = event;
            tideInvocation.addEvent(new ContextEvent(event.getClass().getName(), objectArray));
        }
    }

    protected AsyncPublisher getAsyncPublisher() {
        return null;
    }

    public void prepareCall(ServiceInvocationContext context, IInvocationCall c, String componentName, Class<?> componentClass) {
        String sessionId;
        InvocationCall call = (InvocationCall)c;
        List listeners = call.getListeners();
        List updates = call.getUpdates();
        Object[] results = call.getResults();
        try {
            if (this.manager.getContext(RequestScoped.class).isActive() && this.manager.getContext(SessionScoped.class).isActive() && this.isFirstCall && this.isLogin) {
                for (Map.Entry<ContextResult, Boolean> me : this.getResultsEval().entrySet()) {
                    if (me.getKey().getExpression() != null || !this.findBean(me.getKey().getComponentName(), me.getKey().getComponentClass()).getScope().equals(SessionScoped.class)) continue;
                    me.setValue(Boolean.TRUE);
                }
                this.isLogin = false;
                this.isFirstCall = false;
            }
        }
        catch (ContextNotActiveException me) {
            // empty catch block
        }
        try {
            if (this.manager.getContext(RequestScoped.class).isActive() && this.manager.getContext(ConversationScoped.class).isActive() && this.conversation.isFirstCall()) {
                for (Map.Entry<ContextResult, Boolean> me : this.getResultsEval().entrySet()) {
                    if (me.getKey().getExpression() != null || !this.findBean(me.getKey().getComponentName(), me.getKey().getComponentClass()).getScope().equals(ConversationScoped.class)) continue;
                    me.setValue(Boolean.TRUE);
                }
                this.conversation.setFirstCall(false);
            }
        }
        catch (ContextNotActiveException me) {
            // empty catch block
        }
        if ((sessionId = this.getSessionId()) != null && listeners != null) {
            for (String listener : listeners) {
                try {
                    Class listenerClass = ClassUtil.forName((String)listener);
                    this.tideUserEvents.registerEventType(sessionId, listenerClass);
                }
                catch (ClassNotFoundException e) {
                    log.error("Could not register event " + listener, new Object[]{e});
                }
            }
            if (this.userEvents == null) {
                this.userEvents = this.tideUserEvents.getUserEvents(this.getSessionId());
            }
        }
        boolean instrumented = false;
        Bean<?> bean = this.findBean(componentName, componentClass);
        if (bean != null) {
            boolean bl = instrumented = this.instrumentedBeans.getBean(bean.getBeanClass()) != null;
        }
        if (results != null) {
            Map<ContextResult, Boolean> resultsEval = this.getResultsEval();
            Object[] objectArray = results;
            int n = results.length;
            int n2 = 0;
            while (n2 < n) {
                Object result = objectArray[n2];
                ContextResult cr = (ContextResult)result;
                resultsEval.put(cr, Boolean.TRUE);
                ++n2;
            }
        }
        try {
            this.tideEntityInitializer.restoreLoadedEntities();
        }
        catch (ContextNotActiveException resultsEval) {
            // empty catch block
        }
        DataContext.init();
        DataUpdatePostprocessor dataUpdatePostprocessor = (DataUpdatePostprocessor)this.findComponent(null, DataUpdatePostprocessor.class);
        if (dataUpdatePostprocessor != null) {
            DataContext.get().setDataUpdatePostprocessor(dataUpdatePostprocessor);
        }
        TideInvocation tideInvocation = TideInvocation.init();
        tideInvocation.update(updates);
        if (!instrumented) {
            this.restoreContext(updates, null);
            tideInvocation.updated();
        }
    }

    public IInvocationResult postCall(ServiceInvocationContext context, Object result, String componentName, Class<?> componentClass) {
        TideInvocation tideInvocation = TideInvocation.get();
        int scope = 3;
        boolean restrict = false;
        List<ContextUpdate> results = null;
        results = !tideInvocation.isEvaluated() ? this.evaluateResults(null, false) : tideInvocation.getResults();
        DataContext dataContext = DataContext.get();
        Object[][] updates = dataContext != null ? dataContext.getUpdates() : null;
        Bean<?> bean = null;
        if (componentName != null || componentClass != null) {
            bean = this.findBean(componentName, componentClass);
            if (bean.getScope() == RequestScoped.class) {
                scope = 3;
            } else if (bean.getScope() == ConversationScoped.class) {
                scope = 2;
            } else if (bean.getScope() == SessionScoped.class) {
                scope = 1;
            }
            try {
                if (this.manager.getContext(RequestScoped.class).get(bean) != null) {
                    scope = 3;
                } else if (this.manager.getContext(ConversationScoped.class).get(bean) != null) {
                    scope = 2;
                } else if (this.manager.getContext(SessionScoped.class).get(bean) != null) {
                    scope = 1;
                }
            }
            catch (ContextNotActiveException e) {
                scope = 3;
            }
        }
        InvocationResult res = new InvocationResult(result, results);
        res.setScope(scope);
        res.setRestrict(restrict);
        if (bean != null) {
            if (bean.getBeanClass().isAnnotationPresent(BypassTideMerge.class)) {
                res.setMerge(false);
            } else {
                try {
                    Method m;
                    if (context != null && (m = bean.getBeanClass().getMethod(context.getMethod().getName(), context.getMethod().getParameterTypes())).isAnnotationPresent(BypassTideMerge.class)) {
                        res.setMerge(false);
                    }
                }
                catch (Exception e) {
                    log.warn("Could not find bean method", new Object[]{e});
                }
            }
        }
        res.setUpdates(updates);
        res.setEvents(tideInvocation.getEvents());
        try {
            this.tideEntityInitializer.saveLoadedEntities();
        }
        catch (ContextNotActiveException contextNotActiveException) {
            // empty catch block
        }
        TideInvocation.remove();
        return res;
    }

    public void postCallFault(ServiceInvocationContext context, Throwable t, String componentName, Class<?> componentClass) {
        TideInvocation.remove();
    }

    public void addResultEval(ContextResult result) {
        this.getResultsEval().put(result, Boolean.TRUE);
    }

    private static Object unproxy(Object obj) {
        if (obj instanceof TargetInstanceProxy) {
            try {
                return ((TargetInstanceProxy)obj).getTargetInstance();
            }
            catch (IllegalProductException e) {
                return null;
            }
        }
        return obj;
    }

    public void restoreContext(List<ContextUpdate> updates, Object target) {
        if (updates == null) {
            return;
        }
        try {
            TideInvocation.get().lock();
            GraniteConfig config = GraniteContext.getCurrentInstance().getGraniteConfig();
            for (ContextUpdate update : updates) {
                boolean disabled;
                log.debug("Before invocation: evaluating expression #0(#1).#2", new Object[]{update.getComponentName(), update.getComponentClassName(), update.getExpression()});
                Class componentClass = update.getComponentClass();
                Bean<?> sourceBean = this.findBean(update.getComponentName(), componentClass);
                Object previous = null;
                if (update.getExpression() != null) {
                    boolean disabled2;
                    String[] path = update.getExpression().split("\\.");
                    Object instance = this.manager.getReference(sourceBean, Object.class, this.manager.createCreationalContext(sourceBean));
                    boolean bl = disabled2 = instance != null && config.isComponentTideDisabled(sourceBean.getName(), this.beanClasses(sourceBean), instance);
                    if (disabled2) continue;
                    Object bean = instance = CDIServiceContext.unproxy(instance);
                    Object value = instance;
                    if (update.getValue() != null) {
                        org.granite.util.Entity entity;
                        boolean getPrevious = true;
                        if (update.getValue().getClass().isPrimitive() || CDIServiceContext.isImmutable(update.getValue())) {
                            getPrevious = false;
                        } else if (update.getValue().getClass().getAnnotation(Entity.class) != null && (entity = new org.granite.util.Entity(update.getValue())).getIdentifier() == null) {
                            getPrevious = false;
                        }
                        if (getPrevious) {
                            try {
                                int i = 0;
                                while (i < path.length) {
                                    if (value != null) {
                                        Method getter = Reflections.getGetterMethod(value.getClass(), (String)path[i]);
                                        value = Reflections.invoke((Method)getter, (Object)value, (Object[])new Object[0]);
                                        if (i < path.length - 1) {
                                            bean = value;
                                        }
                                        ++i;
                                        continue;
                                    }
                                    break;
                                }
                            }
                            catch (IllegalArgumentException e) {
                                log.warn((Throwable)e, "Partial merge only", new Object[0]);
                                value = null;
                            }
                            catch (Exception e) {
                                throw new ServiceException("Could not get property: " + update.toString(), (Throwable)e);
                            }
                            previous = value;
                        }
                    }
                    try {
                        if (bean == null) continue;
                        Method setter = Reflections.getSetterMethod(bean.getClass(), (String)path[path.length - 1]);
                        Class<?> type = setter.getParameterTypes()[0];
                        value = GraniteContext.getCurrentInstance().getGraniteConfig().getConverters().convert(update.getValue(), type);
                        value = this.mergeExternal(value, previous);
                        Reflections.invoke((Method)setter, (Object)bean, (Object[])new Object[]{value});
                        continue;
                    }
                    catch (Exception e) {
                        throw new ServiceException("Could not restore property: " + update.toString(), (Throwable)e);
                    }
                }
                previous = this.manager.getReference(sourceBean, Object.class, this.manager.createCreationalContext(sourceBean));
                boolean bl = disabled = previous != null && config.isComponentTideDisabled(sourceBean.getName(), this.beanClasses(sourceBean), previous);
                if (disabled) continue;
                previous = CDIServiceContext.unproxy(previous);
                this.mergeExternal(update.getValue(), previous);
            }
        }
        finally {
            TideInvocation.get().unlock();
        }
    }

    public List<ContextUpdate> evaluateResults(Object target, boolean nothing) {
        ArrayList<ContextUpdate> resultsMap = new ArrayList<ContextUpdate>();
        if (nothing) {
            return resultsMap;
        }
        try {
            TideInvocation.get().lock();
            GraniteConfig config = GraniteContext.getCurrentInstance().getGraniteConfig();
            ClassGetter classGetter = GraniteContext.getCurrentInstance().getGraniteConfig().getClassGetter();
            for (Map.Entry<ContextResult, Boolean> me : this.getResultsEval().entrySet()) {
                Object value;
                if (!me.getValue().booleanValue()) continue;
                ContextResult res = me.getKey();
                Class componentClass = res.getComponentClass();
                Bean<?> targetBean = this.findBean(res.getComponentName(), componentClass);
                if (targetBean == null) {
                    log.warn("Target bean " + res.getComponentName() + " of class " + componentClass + " not found", new Object[0]);
                    continue;
                }
                String targetComponentName = targetBean.getName();
                boolean add = true;
                Class scopeType = targetBean.getScope();
                Boolean restrict = res.getRestrict();
                Object object = value = res instanceof ScopedContextResult ? ((ScopedContextResult)res).getValue() : this.manager.getReference(targetBean, Object.class, this.manager.createCreationalContext(targetBean));
                if (value != null && config.isComponentTideDisabled(targetComponentName, this.beanClasses(targetBean), value)) {
                    add = false;
                }
                if (add) {
                    this.getResultsEval().put(res, false);
                    String[] path = res.getExpression() != null ? res.getExpression().split("\\.") : new String[]{};
                    value = CDIServiceContext.unproxy(value);
                    if (value != null) {
                        try {
                            int i = 0;
                            while (i < path.length) {
                                if (value == null) break;
                                try {
                                    Method getter = Reflections.getGetterMethod(value.getClass(), (String)path[i]);
                                    value = Reflections.invoke((Method)getter, (Object)value, (Object[])new Object[0]);
                                }
                                catch (IllegalArgumentException e) {
                                    add = false;
                                }
                                ++i;
                            }
                        }
                        catch (Exception e) {
                            throw new ServiceException("Could not evaluate expression " + res.toString(), (Throwable)e);
                        }
                    }
                    if (add && value != null && classGetter != null) {
                        classGetter.initialize(null, null, value);
                        int scope = 3;
                        if (scopeType == ConversationScoped.class) {
                            scope = 2;
                        } else if (scopeType == SessionScoped.class) {
                            scope = 1;
                        }
                        ContextUpdate cu = new ContextUpdate(res.getComponentName(), res.getExpression(), value, scope, Boolean.TRUE.equals(restrict));
                        cu.setComponentClassName(res.getComponentClassName());
                        resultsMap.add(cu);
                        add = false;
                    }
                }
                me.setValue(Boolean.FALSE);
            }
            ArrayList<ContextUpdate> arrayList = resultsMap;
            return arrayList;
        }
        finally {
            TideInvocation.get().unlock();
        }
    }

    protected TidePersistenceManager getTidePersistenceManager(boolean create) {
        return this.initializer.getPersistenceManager();
    }

    protected boolean equals(Object obj1, Object obj2) {
        if (super.equals(obj1, obj2)) {
            return true;
        }
        return obj1 != null && obj2 != null && (obj1.getClass().isAnnotationPresent(TideBean.class) || obj2.getClass().isAnnotationPresent(TideBean.class));
    }

    public static boolean isImmutable(Object o) {
        return KNOWN_IMMUTABLES.contains(o.getClass()) || Enum.class.isInstance(o);
    }
}

