/*
 * Decompiled with CFR 0.152.
 */
package org.granite.tide.cdi;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessBean;
import javax.enterprise.inject.spi.ProcessProducerField;
import javax.enterprise.inject.spi.ProcessProducerMethod;
import javax.enterprise.util.AnnotationLiteral;
import javax.inject.Inject;
import javax.inject.Named;
import org.granite.logging.Logger;
import org.granite.messaging.amf.io.util.externalizer.annotation.ExternalizedBean;
import org.granite.messaging.service.annotations.RemoteDestination;
import org.granite.tide.annotations.TideEnabled;
import org.granite.tide.cdi.TideBean;
import org.granite.tide.cdi.TideComponent;
import org.granite.tide.cdi.TideInstrumentedBeans;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TideExtension
implements Extension {
    private static final Logger log = Logger.getLogger(TideExtension.class);
    @Inject
    BeanManager manager;
    private Bean<?> tideInstrumentedBeans = null;
    private Map<Type, Bean<?>> instrumentedBeans = new HashMap();
    private Map<Object, Type> producedBeans = new HashMap<Object, Type>();

    public <X> void processAnnotatedType(@Observes ProcessAnnotatedType<X> event) {
        AnnotatedType annotatedType = event.getAnnotatedType();
        boolean tideComponent = false;
        boolean tideBean = false;
        for (Type type : annotatedType.getTypeClosure()) {
            if (type instanceof ParameterizedType) {
                type = ((ParameterizedType)type).getRawType();
            }
            if (type instanceof Class && (((Class)type).isAnnotationPresent(RemoteDestination.class) || ((Class)type).isAnnotationPresent(TideEnabled.class) || ((Class)type).isAnnotationPresent(Named.class) || ((Class)type).isAnnotationPresent(RequestScoped.class))) {
                tideComponent = true;
                break;
            }
            if (!(type instanceof Class) || (!Serializable.class.isAssignableFrom((Class)type) || !((Class)type).isAnnotationPresent(Named.class)) && !((Class)type).isAnnotationPresent(ExternalizedBean.class)) continue;
            tideBean = true;
            break;
        }
        if (tideComponent || tideBean) {
            event.setAnnotatedType(new TideAnnotatedType(annotatedType, tideComponent, tideBean));
        }
    }

    public <X> void processBean(@Observes ProcessBean<X> event) {
        if (event.getAnnotated().isAnnotationPresent(TideComponent.class) || event.getAnnotated().isAnnotationPresent(TideBean.class)) {
            this.instrumentedBeans.put(event.getAnnotated().getBaseType(), event.getBean());
            log.info("Instrumented Tide component %s", new Object[]{event.getBean().toString()});
        }
        Bean bean = event.getBean();
        if (event instanceof ProcessProducerMethod) {
            Type type = ((ProcessProducerMethod)event).getAnnotatedProducerMethod().getDeclaringType().getBaseType();
            this.producedBeans.put(((ProcessProducerMethod)event).getAnnotatedProducerMethod().getBaseType(), type);
            if (bean.getName() != null) {
                this.producedBeans.put(bean.getName(), type);
            }
        } else if (event instanceof ProcessProducerField) {
            Type type = ((ProcessProducerField)event).getAnnotatedProducerField().getDeclaringType().getBaseType();
            this.producedBeans.put(((ProcessProducerField)event).getAnnotatedProducerField().getBaseType(), type);
            if (bean.getName() != null) {
                this.producedBeans.put(bean.getName(), type);
            }
        }
        if (event.getBean().getBeanClass().equals(TideInstrumentedBeans.class)) {
            this.tideInstrumentedBeans = event.getBean();
        }
    }

    public void processAfterBeanDiscovery(@Observes AfterBeanDiscovery event, BeanManager manager) {
        TideInstrumentedBeans ib = (TideInstrumentedBeans)manager.getReference(this.tideInstrumentedBeans, TideInstrumentedBeans.class, manager.createCreationalContext(this.tideInstrumentedBeans));
        ib.setBeans(this.instrumentedBeans);
        ib.setProducedBeans(this.producedBeans);
    }

    public void processAfterDeploymentValidation(@Observes AfterDeploymentValidation event, BeanManager manager) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TideAnnotatedType<T>
    implements AnnotatedType<T> {
        private final AnnotatedType<T> annotatedType;
        private final Annotation componentQualifier = new AnnotationLiteral<TideComponent>(){};
        private final Annotation beanQualifier = new AnnotationLiteral<TideBean>(){};
        private final Set<Annotation> annotations;

        public TideAnnotatedType(AnnotatedType<T> annotatedType, boolean component, boolean bean) {
            this.annotatedType = annotatedType;
            this.annotations = new HashSet<Annotation>(annotatedType.getAnnotations());
            if (component) {
                this.annotations.add(this.componentQualifier);
            }
            if (bean) {
                this.annotations.add(this.beanQualifier);
            }
        }

        public Set<AnnotatedConstructor<T>> getConstructors() {
            return this.annotatedType.getConstructors();
        }

        public Set<AnnotatedField<? super T>> getFields() {
            return this.annotatedType.getFields();
        }

        public Class<T> getJavaClass() {
            return this.annotatedType.getJavaClass();
        }

        public Set<AnnotatedMethod<? super T>> getMethods() {
            return this.annotatedType.getMethods();
        }

        public <X extends Annotation> X getAnnotation(Class<X> annotationClass) {
            if (annotationClass.equals(TideComponent.class)) {
                return (X)this.componentQualifier;
            }
            if (annotationClass.equals(TideBean.class)) {
                return (X)this.beanQualifier;
            }
            return (X)this.annotatedType.getAnnotation(annotationClass);
        }

        public Set<Annotation> getAnnotations() {
            return this.annotations;
        }

        public Type getBaseType() {
            return this.annotatedType.getBaseType();
        }

        public Set<Type> getTypeClosure() {
            return this.annotatedType.getTypeClosure();
        }

        public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
            if (annotationClass.equals(TideComponent.class) && this.annotations.contains(this.componentQualifier)) {
                return true;
            }
            if (annotationClass.equals(TideBean.class) && this.annotations.contains(this.beanQualifier)) {
                return true;
            }
            return this.annotatedType.isAnnotationPresent(annotationClass);
        }
    }
}

