/*
 * Decompiled with CFR 0.152.
 */
package org.granite.tide.cdi;

import java.lang.annotation.Annotation;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import javax.enterprise.util.AnnotationLiteral;
import javax.inject.Inject;
import javax.servlet.ServletContext;
import org.granite.context.GraniteContext;
import org.granite.gravity.Gravity;
import org.granite.gravity.GravityManager;
import org.granite.messaging.webapp.HttpGraniteContext;

public class TideGravity {
    @Inject
    Instance<ServletContext> servletContextInstance;
    private static final AnnotationLiteral<Default> DEFAULT_LITERAL = new AnnotationLiteral<Default>(){};

    @Produces
    @RequestScoped
    public Gravity getGravity() {
        ServletContext servletContext = null;
        if (!this.servletContextInstance.isUnsatisfied()) {
            servletContext = (ServletContext)this.servletContextInstance.select(new Annotation[]{DEFAULT_LITERAL}).get();
        } else {
            GraniteContext graniteContext = GraniteContext.getCurrentInstance();
            if (graniteContext == null || !(graniteContext instanceof HttpGraniteContext)) {
                throw new RuntimeException("Gravity not found: not in a GraniteDS HTTP context");
            }
            servletContext = ((HttpGraniteContext)graniteContext).getServletContext();
        }
        return GravityManager.getGravity((ServletContext)servletContext);
    }
}

