/*
 * Decompiled with CFR 0.152.
 */
package org.granite.tide.cdi;

import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.spi.Bean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ApplicationScoped
public class TideInstrumentedBeans
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map<Type, Bean<?>> beans = null;
    private Map<Object, Type> producedBeans = null;

    public void setBeans(Map<Type, Bean<?>> beans) {
        this.beans = beans;
    }

    public Bean<?> getBean(Type type) {
        Bean<?> bean = this.beans.get(type);
        if (bean != null) {
            return bean;
        }
        if (type instanceof Class) {
            Class clazz = (Class)type;
            if (clazz.getSuperclass() != null) {
                bean = this.beans.get(clazz.getSuperclass());
            }
            if (bean != null) {
                return bean;
            }
            Class<?>[] classArray = clazz.getInterfaces();
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> i = classArray[n2];
                bean = this.beans.get(i);
                if (bean != null) {
                    return bean;
                }
                ++n2;
            }
        }
        return null;
    }

    public void setProducedBeans(Map<Object, Type> producedBeans) {
        this.producedBeans = new HashMap<Object, Type>();
        for (Map.Entry<Object, Type> me : producedBeans.entrySet()) {
            if (!this.beans.containsKey(me.getValue())) continue;
            this.producedBeans.put(me.getKey(), me.getValue());
        }
    }

    public boolean isProducedBy(Object name, Type clazz) {
        Class beanClass = (Class)this.producedBeans.get(name);
        return beanClass != null ? beanClass.isAssignableFrom((Class)clazz) : false;
    }
}

