/*
 * Decompiled with CFR 0.152.
 */
package org.granite.config;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.granite.config.ActionScriptClassDescriptorFactory;
import org.granite.config.ConfigurableFactory;
import org.granite.config.ExternalizerFactory;
import org.granite.config.GraniteConfigException;
import org.granite.config.JavaClassDescriptorFactory;
import org.granite.config.TideComponentMatcherFactory;
import org.granite.logging.Logger;
import org.granite.messaging.amf.io.AMF3Deserializer;
import org.granite.messaging.amf.io.AMF3Serializer;
import org.granite.messaging.amf.io.convert.Converter;
import org.granite.messaging.amf.io.convert.Converters;
import org.granite.messaging.amf.io.util.ActionScriptClassDescriptor;
import org.granite.messaging.amf.io.util.ClassGetter;
import org.granite.messaging.amf.io.util.DefaultClassGetter;
import org.granite.messaging.amf.io.util.JavaClassDescriptor;
import org.granite.messaging.amf.io.util.externalizer.Externalizer;
import org.granite.messaging.amf.process.AMF3MessageInterceptor;
import org.granite.messaging.service.DefaultMethodMatcher;
import org.granite.messaging.service.ExceptionConverter;
import org.granite.messaging.service.MethodMatcher;
import org.granite.messaging.service.ServiceInvocationListener;
import org.granite.messaging.service.security.SecurityService;
import org.granite.messaging.service.tide.TideComponentMatcher;
import org.granite.scan.ScannedItem;
import org.granite.scan.ScannedItemHandler;
import org.granite.scan.Scanner;
import org.granite.util.ClassUtil;
import org.granite.util.StreamUtil;
import org.granite.util.XMap;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraniteConfig
implements ScannedItemHandler {
    private static final Logger log = Logger.getLogger(GraniteConfig.class);
    private static final String GRANITE_CONFIG_PUBLIC_ID = "-//Granite Data Services//DTD granite-config internal//EN";
    private static final String GRANITE_CONFIG_KEY = String.valueOf(GraniteConfig.class.getName()) + "_CACHE";
    private static final String GRANITE_CONFIG_PROPERTIES = "META-INF/granite-config.properties";
    private static final ExternalizerFactory EXTERNALIZER_FACTORY = new ExternalizerFactory();
    private static final ActionScriptClassDescriptorFactory ASC_DESCRIPTOR_FACTORY = new ActionScriptClassDescriptorFactory();
    private static final JavaClassDescriptorFactory JC_DESCRIPTOR_FACTORY = new JavaClassDescriptorFactory();
    private static final TideComponentMatcherFactory TIDE_COMPONENT_MATCHER_FACTORY = new TideComponentMatcherFactory();
    private boolean scan = false;
    private Constructor<AMF3Serializer> amf3SerializerConstructor = null;
    private Constructor<AMF3Deserializer> amf3DeserializerConstructor = null;
    private AMF3MessageInterceptor amf3MessageInterceptor = null;
    private List<Class<? extends Converter>> converterClasses = new ArrayList<Class<? extends Converter>>();
    private Converters converters = null;
    private MethodMatcher methodMatcher = new DefaultMethodMatcher();
    private ServiceInvocationListener invocationListener = null;
    private final Map<String, String> instanciators = new HashMap<String, String>();
    private ClassGetter classGetter = new DefaultClassGetter();
    private boolean classGetterSet = false;
    private final List<Externalizer> scannedExternalizers = new ArrayList<Externalizer>();
    private final ConcurrentHashMap<String, Externalizer> externalizersByType = new ConcurrentHashMap();
    private final Map<String, String> externalizersByInstanceOf = new HashMap<String, String>();
    private final Map<String, String> externalizersByAnnotatedWith = new HashMap<String, String>();
    private final ConcurrentHashMap<String, Class<? extends JavaClassDescriptor>> javaDescriptorsByType = new ConcurrentHashMap();
    private final Map<String, String> javaDescriptorsByInstanceOf = new HashMap<String, String>();
    private final ConcurrentHashMap<String, Class<? extends ActionScriptClassDescriptor>> as3DescriptorsByType = new ConcurrentHashMap();
    private final Map<String, String> as3DescriptorsByInstanceOf = new HashMap<String, String>();
    private final List<ExceptionConverter> exceptionConverters = new ArrayList<ExceptionConverter>();
    private final ConcurrentHashMap<String, Boolean> tideComponentsByName = new ConcurrentHashMap();
    private final List<TideComponentMatcher> tideComponentMatchers = new ArrayList<TideComponentMatcher>();
    private SecurityService securityService = null;
    private Constructor<?> messageSelectorConstructor;

    private GraniteConfig() {
        try {
            this.amf3SerializerConstructor = ClassUtil.getConstructor(AMF3Serializer.class, new Class[]{OutputStream.class});
            this.amf3DeserializerConstructor = ClassUtil.getConstructor(AMF3Deserializer.class, new Class[]{InputStream.class});
        }
        catch (Exception e) {
            throw new GraniteConfigException("Could not get constructor for AMF3 (de)serializers", e);
        }
    }

    public boolean getScan() {
        return this.scan;
    }

    private void scanConfig() {
        Scanner scanner = new Scanner((ScannedItemHandler)this, GRANITE_CONFIG_PROPERTIES);
        try {
            scanner.scan();
        }
        catch (Exception e) {
            log.error(e, "Could not scan classpath for configuration", new Object[0]);
        }
    }

    @Override
    public void handleMarkerItem(ScannedItem item) {
        try {
            this.handleProperties(item.loadAsProperties());
        }
        catch (Exception e) {
            log.error(e, "Could not load properties: %s", item);
        }
    }

    @Override
    public void handleScannedItem(ScannedItem item) {
        if ("class".equals(item.getExtension()) && item.getName().indexOf(36) == -1) {
            try {
                this.handleClass(item.loadAsClass());
            }
            catch (NoClassDefFoundError e) {
                if (!e.getMessage().startsWith("org/granite/gravity")) {
                    log.error(e, "Could not load class: %s", item);
                }
            }
            catch (Throwable t) {
                log.error(t, "Could not load class: %s", item);
            }
        }
    }

    private void handleProperties(Properties properties) {
        String classGetterName = properties.getProperty("classGetter");
        if (!this.classGetterSet && classGetterName != null) {
            try {
                this.classGetter = ClassUtil.newInstance(classGetterName, ClassGetter.class);
            }
            catch (Throwable t) {
                log.error(t, "Could not create instance of: %s", classGetterName);
            }
        }
        String amf3MessageInterceptorName = properties.getProperty("amf3MessageInterceptor");
        if (this.amf3MessageInterceptor == null && amf3MessageInterceptorName != null) {
            try {
                this.amf3MessageInterceptor = ClassUtil.newInstance(amf3MessageInterceptorName, AMF3MessageInterceptor.class);
            }
            catch (Throwable t) {
                log.error(t, "Could not create instance of: %s", amf3MessageInterceptorName);
            }
        }
    }

    private void handleClass(Class<?> clazz) {
        if (!clazz.isInterface() && !Modifier.isAbstract(clazz.getModifiers())) {
            if (Externalizer.class.isAssignableFrom(clazz)) {
                try {
                    this.scannedExternalizers.add(ClassUtil.newInstance(clazz, Externalizer.class));
                }
                catch (Exception e) {
                    log.error(e, "Could not create new instance of: %s", clazz);
                }
            }
            if (ExceptionConverter.class.isAssignableFrom(clazz)) {
                try {
                    this.exceptionConverters.add(ClassUtil.newInstance(clazz, ExceptionConverter.class));
                }
                catch (Exception e) {
                    log.error(e, "Could not create new instance of: %s", clazz);
                }
            }
        }
    }

    public static synchronized GraniteConfig loadConfig(ServletContext context) throws ServletException {
        GraniteConfig graniteConfig = (GraniteConfig)context.getAttribute(GRANITE_CONFIG_KEY);
        if (graniteConfig == null) {
            InputStream is;
            String path = context.getInitParameter("graniteConfigPath");
            if (path == null) {
                path = "/WEB-INF/granite/granite-config.xml";
            }
            if ((is = context.getResourceAsStream(path)) == null) {
                log.warn("Could not load custom granite-config.xml: %s (file does not exists)", path);
                path = null;
            }
            try {
                graniteConfig = GraniteConfig.loadConfig(is);
            }
            catch (Exception e) {
                throw new ServletException("Could not load custom granite-config.xml", (Throwable)e);
            }
            context.setAttribute(GRANITE_CONFIG_KEY, (Object)graniteConfig);
        }
        return graniteConfig;
    }

    public static GraniteConfig loadConfig(InputStream customConfigIs) throws IOException, SAXException {
        XMap doc;
        GraniteConfig config = null;
        final ByteArrayInputStream dtd = StreamUtil.getResourceAsStream("org/granite/config/granite-config.dtd");
        EntityResolver resolver = new EntityResolver(){

            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                if (GraniteConfig.GRANITE_CONFIG_PUBLIC_ID.equals(publicId)) {
                    dtd.reset();
                    InputSource source = new InputSource(dtd);
                    source.setPublicId(publicId);
                    return source;
                }
                return null;
            }
        };
        InputStream is = null;
        try {
            is = Thread.currentThread().getContextClassLoader().getResourceAsStream("org/granite/config/granite-config.xml");
            doc = new XMap(is, resolver);
            config = GraniteConfig.forElement(new GraniteConfig(), doc, false);
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        if (customConfigIs != null) {
            doc = new XMap(customConfigIs, resolver);
            config = GraniteConfig.forElement(config, doc, true);
        }
        return config;
    }

    public ObjectOutput newAMF3Serializer(OutputStream out) {
        try {
            return this.amf3SerializerConstructor.newInstance(out);
        }
        catch (Exception e) {
            throw new GraniteConfigException("Could not create serializer instance with: " + this.amf3SerializerConstructor, e);
        }
    }

    public ObjectInput newAMF3Deserializer(InputStream in) {
        try {
            return this.amf3DeserializerConstructor.newInstance(in);
        }
        catch (Exception e) {
            throw new GraniteConfigException("Could not create deserializer instance with: " + this.amf3DeserializerConstructor, e);
        }
    }

    public AMF3MessageInterceptor getAmf3MessageInterceptor() {
        return this.amf3MessageInterceptor;
    }

    public Converters getConverters() {
        return this.converters;
    }

    public MethodMatcher getMethodMatcher() {
        return this.methodMatcher;
    }

    public ServiceInvocationListener getInvocationListener() {
        return this.invocationListener;
    }

    public String getInstanciator(String type) {
        return this.instanciators.get(type);
    }

    public ClassGetter getClassGetter() {
        return this.classGetter;
    }

    public Externalizer getExternalizer(String type) {
        return GraniteConfig.getElementByType(type, EXTERNALIZER_FACTORY, this.externalizersByType, this.externalizersByInstanceOf, this.externalizersByAnnotatedWith, this.scannedExternalizers);
    }

    public Class<? extends ActionScriptClassDescriptor> getActionScriptDescriptor(String type) {
        return GraniteConfig.getElementByType(type, ASC_DESCRIPTOR_FACTORY, this.as3DescriptorsByType, this.as3DescriptorsByInstanceOf, null, null);
    }

    public Class<? extends JavaClassDescriptor> getJavaDescriptor(String type) {
        return GraniteConfig.getElementByType(type, JC_DESCRIPTOR_FACTORY, this.javaDescriptorsByType, this.javaDescriptorsByInstanceOf, null, null);
    }

    public boolean isComponentTideEnabled(String componentName, Class<?> componentClass, Object instance) {
        return TideComponentMatcherFactory.isComponentTideEnabled(this.tideComponentsByName, this.tideComponentMatchers, componentName, componentClass, instance);
    }

    public List<ExceptionConverter> getExceptionConverters() {
        return this.exceptionConverters;
    }

    public boolean hasSecurityService() {
        return this.securityService != null;
    }

    public SecurityService getSecurityService() {
        return this.securityService;
    }

    public Constructor<?> getMessageSelectorConstructor() {
        return this.messageSelectorConstructor;
    }

    private static GraniteConfig forElement(GraniteConfig config, XMap element, boolean custom) {
        String scan = element.get("@scan");
        config.scan = "true".equals(scan);
        GraniteConfig.loadCustomAMF3Serializer(config, element, custom);
        GraniteConfig.loadCustomAMF3MessageInterceptor(config, element, custom);
        GraniteConfig.loadCustomConverters(config, element, custom);
        GraniteConfig.loadCustomMethodMatcher(config, element, custom);
        GraniteConfig.loadCustomInvocationListener(config, element, custom);
        GraniteConfig.loadCustomInstanciators(config, element, custom);
        GraniteConfig.loadCustomClassGetter(config, element, custom);
        GraniteConfig.loadCustomExternalizers(config, element, custom);
        GraniteConfig.loadCustomDescriptors(config, element, custom);
        GraniteConfig.loadCustomExceptionConverters(config, element, custom);
        GraniteConfig.loadCustomTideComponents(config, element, custom);
        GraniteConfig.loadCustomSecurity(config, element, custom);
        GraniteConfig.loadCustomMessageSelector(config, element, custom);
        if (config.scan) {
            config.scanConfig();
        }
        return config;
    }

    private static void loadCustomAMF3Serializer(GraniteConfig config, XMap element, boolean custom) {
        XMap amf3Deserializer;
        XMap amf3Serializer = element.getOne("amf3serializer");
        if (amf3Serializer != null) {
            String type = amf3Serializer.get("@type");
            try {
                Class<AMF3Serializer> amf3SerializerClass = ClassUtil.forName(type, AMF3Serializer.class);
                config.amf3SerializerConstructor = ClassUtil.getConstructor(amf3SerializerClass, new Class[]{OutputStream.class});
            }
            catch (Exception e) {
                throw new GraniteConfigException("Could not get constructor for AMF3 serializer: " + type, e);
            }
        }
        if ((amf3Deserializer = element.getOne("amf3deserializer")) != null) {
            String type = amf3Deserializer.get("@type");
            try {
                Class<AMF3Deserializer> amf3DeserializerClass = ClassUtil.forName(type, AMF3Deserializer.class);
                config.amf3DeserializerConstructor = ClassUtil.getConstructor(amf3DeserializerClass, new Class[]{InputStream.class});
            }
            catch (Exception e) {
                throw new GraniteConfigException("Could not get constructor for AMF3 deserializer: " + type, e);
            }
        }
    }

    private static void loadCustomAMF3MessageInterceptor(GraniteConfig config, XMap element, boolean custom) {
        XMap methodMatcher = element.getOne("amf3messageinterceptor");
        if (methodMatcher != null) {
            String type = methodMatcher.get("@type");
            try {
                config.amf3MessageInterceptor = (AMF3MessageInterceptor)ClassUtil.newInstance(type);
            }
            catch (Exception e) {
                throw new GraniteConfigException("Could not construct amf3 message interceptor: " + type, e);
            }
        }
    }

    private static void loadCustomConverters(GraniteConfig config, XMap element, boolean custom) {
        XMap converters = element.getOne("converters");
        if (converters != null) {
            String override = converters.get("@override");
            if ("true".equals(override)) {
                config.converterClasses.clear();
            }
            int i = 0;
            for (XMap converter : converters.getAll("converter")) {
                String type = converter.get("@type");
                try {
                    config.converterClasses.add(i++, ClassUtil.forName(type, Converter.class));
                }
                catch (Exception e) {
                    throw new GraniteConfigException("Could not get converter class for: " + type, e);
                }
            }
        }
        try {
            config.converters = new Converters(config.converterClasses);
        }
        catch (Exception e) {
            throw new GraniteConfigException("Could not construct new Converters instance", e);
        }
        if (custom) {
            config.converterClasses = null;
        }
    }

    private static void loadCustomMethodMatcher(GraniteConfig config, XMap element, boolean custom) {
        XMap methodMatcher = element.getOne("methodmatcher");
        if (methodMatcher != null) {
            String type = methodMatcher.get("@type");
            try {
                config.methodMatcher = (MethodMatcher)ClassUtil.newInstance(type);
            }
            catch (Exception e) {
                throw new GraniteConfigException("Could not construct method matcher: " + type, e);
            }
        }
    }

    private static void loadCustomInvocationListener(GraniteConfig config, XMap element, boolean custom) {
        XMap invocationListener = element.getOne("invocationlistener");
        if (invocationListener != null) {
            String type = invocationListener.get("@type");
            try {
                config.invocationListener = (ServiceInvocationListener)ClassUtil.newInstance(type);
            }
            catch (Exception e) {
                throw new GraniteConfigException("Could not instantiate ServiceInvocationListener: " + type, e);
            }
        }
    }

    private static void loadCustomInstanciators(GraniteConfig config, XMap element, boolean custom) {
        XMap instanciators = element.getOne("instanciators");
        if (instanciators != null) {
            for (XMap instanciator : instanciators.getAll("instanciator")) {
                config.instanciators.put(instanciator.get("@type"), instanciator.get("."));
            }
        }
    }

    private static void loadCustomClassGetter(GraniteConfig config, XMap element, boolean custom) {
        XMap classGetter = element.getOne("classgetter");
        if (classGetter != null) {
            String type = classGetter.get("@type");
            try {
                config.classGetter = (ClassGetter)ClassUtil.newInstance(type);
                config.classGetterSet = true;
            }
            catch (Exception e) {
                throw new GraniteConfigException("Could not instantiate ClassGetter: " + type, e);
            }
        }
    }

    private static void loadCustomExternalizers(GraniteConfig config, XMap element, boolean custom) {
        for (XMap externalizer : element.getAll("externalizers/externalizer")) {
            String externalizerType = externalizer.get("@type");
            for (XMap include : externalizer.getAll("include")) {
                String type = include.get("@type");
                if (type != null) {
                    config.externalizersByType.put(type, EXTERNALIZER_FACTORY.getInstance(externalizerType));
                    continue;
                }
                String instanceOf = include.get("@instanceof");
                if (instanceOf != null) {
                    config.externalizersByInstanceOf.put(instanceOf, externalizerType);
                    continue;
                }
                String annotatedWith = include.get("@annotatedwith");
                if (annotatedWith == null) {
                    throw new GraniteConfigException("Element 'include' has no attribute 'type', 'instanceof' or 'annotatedwith'");
                }
                config.externalizersByAnnotatedWith.put(annotatedWith, externalizerType);
            }
        }
    }

    private static void loadCustomDescriptors(GraniteConfig config, XMap element, boolean custom) {
        for (XMap descriptor : element.getAll("descriptors/descriptor")) {
            String type = descriptor.get("@type");
            if (type != null) {
                String java = descriptor.get("@java");
                String as3 = descriptor.get("@as3");
                if (java == null && as3 == null) {
                    throw new GraniteConfigException("Element 'descriptor' has no attributes 'java' or 'as3'\n" + descriptor);
                }
                if (java != null) {
                    config.javaDescriptorsByType.put(type, (Class<? extends JavaClassDescriptor>)JC_DESCRIPTOR_FACTORY.getInstance(java));
                }
                if (as3 == null) continue;
                config.as3DescriptorsByType.put(type, (Class<? extends ActionScriptClassDescriptor>)ASC_DESCRIPTOR_FACTORY.getInstance(as3));
                continue;
            }
            String instanceOf = descriptor.get("@instanceof");
            if (instanceOf == null) {
                throw new GraniteConfigException("Element 'descriptor' has no attribute 'type' or 'instanceof'\n" + descriptor);
            }
            String java = descriptor.get("@java");
            String as3 = descriptor.get("@as3");
            if (java == null && as3 == null) {
                throw new GraniteConfigException("Element 'descriptor' has no attributes 'java' or 'as3' in:\n" + descriptor);
            }
            if (java != null) {
                config.javaDescriptorsByInstanceOf.put(instanceOf, java);
            }
            if (as3 == null) continue;
            config.as3DescriptorsByInstanceOf.put(instanceOf, as3);
        }
    }

    private static void loadCustomExceptionConverters(GraniteConfig config, XMap element, boolean custom) {
        for (XMap exceptionConverter : element.getAll("exceptionconverters/exceptionconverter")) {
            String type = exceptionConverter.get("@type");
            ExceptionConverter converter = null;
            try {
                converter = (ExceptionConverter)ClassUtil.newInstance(type);
                config.exceptionConverters.add(converter);
            }
            catch (Exception e) {
                throw new GraniteConfigException("Could not construct method matcher: " + type, e);
            }
        }
    }

    private static void loadCustomTideComponents(GraniteConfig config, XMap element, boolean custom) {
        for (XMap component : element.getAll("tide-components/component")) {
            String instanceOf;
            String type = component.get("@type");
            if (type != null) {
                config.tideComponentMatchers.add(TIDE_COMPONENT_MATCHER_FACTORY.getTypeMatcher(type));
                continue;
            }
            String name = component.get("@name");
            if (name != null) {
                config.tideComponentMatchers.add(TIDE_COMPONENT_MATCHER_FACTORY.getNameMatcher(name));
            }
            if ((instanceOf = component.get("@instanceof")) != null) {
                config.tideComponentMatchers.add(TIDE_COMPONENT_MATCHER_FACTORY.getInstanceOfMatcher(instanceOf));
                continue;
            }
            String annotatedWith = component.get("@annotatedwith");
            if (annotatedWith == null) {
                throw new GraniteConfigException("Element 'component' has no attribute 'type', 'name', 'instanceof' or 'annotatedwith'");
            }
            config.tideComponentMatchers.add(TIDE_COMPONENT_MATCHER_FACTORY.getAnnotatedWithMatcher(annotatedWith));
        }
    }

    private static void loadCustomSecurity(GraniteConfig config, XMap element, boolean custom) {
        XMap security = element.getOne("security");
        if (security != null) {
            String type = security.get("@type");
            try {
                config.securityService = (SecurityService)ClassUtil.newInstance(type);
            }
            catch (Exception e) {
                throw new GraniteConfigException("Could not instantiate SecurityService: " + type, e);
            }
            HashMap<String, String> params = new HashMap<String, String>();
            for (XMap param : security.getAll("param")) {
                String name = param.get("@name");
                String value = param.get("@value");
                params.put(name, value);
            }
            try {
                config.securityService.configure(params);
            }
            catch (Exception e) {
                throw new GraniteConfigException("Could not configure SecurityService " + type + " with: " + params, e);
            }
        }
    }

    private static void loadCustomMessageSelector(GraniteConfig config, XMap element, boolean custom) {
        XMap selector = element.getOne("messageselector");
        if (selector != null) {
            String type = selector.get("@type");
            try {
                config.messageSelectorConstructor = ClassUtil.getConstructor(type, new Class[]{String.class});
            }
            catch (Exception e) {
                throw new GraniteConfigException("Could not construct message selector: " + type, e);
            }
        }
    }

    private static <T> T getElementByType(String type, ConfigurableFactory<T> factory, ConcurrentHashMap<String, T> elementsByType, Map<String, String> elementsByInstanceOf, Map<String, String> elementsByAnnotatedWith, List<T> scannedConfigurables) {
        T previous;
        T NULL = factory.getNullInstance();
        T element = elementsByType.get(type);
        if (element != null) {
            return NULL == element ? null : (T)element;
        }
        element = NULL;
        Class<?> typeClass = null;
        try {
            typeClass = ClassUtil.forName(type);
        }
        catch (Exception e) {
            throw new GraniteConfigException("Could not load class: " + type, e);
        }
        for (Map.Entry<String, String> entry : elementsByInstanceOf.entrySet()) {
            String instanceOf = entry.getKey();
            try {
                Class<?> instanceOfClass = ClassUtil.forName(instanceOf);
                if (!instanceOfClass.isAssignableFrom(typeClass)) continue;
                element = factory.getInstance(entry.getValue());
                break;
            }
            catch (Exception e) {
                throw new GraniteConfigException("Could not load class: " + instanceOf, e);
            }
        }
        if (elementsByAnnotatedWith != null && NULL == element) {
            for (Map.Entry<String, String> entry : elementsByAnnotatedWith.entrySet()) {
                String annotation = entry.getKey();
                try {
                    Class<Annotation> annotationClass = ClassUtil.forName(annotation, Annotation.class);
                    if (!typeClass.isAnnotationPresent(annotationClass)) continue;
                    element = factory.getInstance(entry.getValue());
                    break;
                }
                catch (Exception e) {
                    throw new GraniteConfigException("Could not load class: " + annotation, e);
                }
            }
        }
        if (NULL == element) {
            element = factory.getInstanceForBean(scannedConfigurables, typeClass);
        }
        if ((previous = elementsByType.putIfAbsent(type, element)) != null) {
            element = previous;
        }
        return NULL == element ? null : (T)element;
    }
}

