/*
 * Decompiled with CFR 0.152.
 */
package org.granite.logging;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Formattable;
import java.util.HashMap;
import java.util.Map;
import org.granite.logging.LoggingFormatter;

public class DefaultLoggingFormatter
implements LoggingFormatter {
    private static final int MAX_COLLECTION_ITEMS = 100;
    private final int maxItems;

    public DefaultLoggingFormatter() {
        this(100);
    }

    public DefaultLoggingFormatter(int maxItems) {
        this.maxItems = maxItems;
    }

    public String format(String message, Object ... args) {
        try {
            int i = 0;
            while (i < args.length) {
                args[i] = this.convert(args[i]);
                ++i;
            }
            return String.format(message, args);
        }
        catch (Exception e) {
            try {
                return "[FORMATTER ERROR] \"" + message + "\"(" + Arrays.toString(args) + ") - " + e;
            }
            catch (Exception f) {
                return "[FORMATTER ERROR] \"" + message + "\"(" + f + ") - " + e;
            }
        }
    }

    protected Object convert(Object o) {
        if (o == null || o instanceof Formattable || o instanceof Number || o instanceof Character || o instanceof Boolean || o instanceof Date || o instanceof Calendar) {
            return o;
        }
        try {
            if (o instanceof String) {
                o = "" + '\"' + o + '\"';
            } else if (o.getClass().isArray()) {
                Class<?> type = o.getClass().getComponentType();
                if (this.maxItems < 0) {
                    if (type.isPrimitive()) {
                        if (type == Byte.TYPE) {
                            return Arrays.toString((byte[])o);
                        }
                        if (type == Character.TYPE) {
                            return Arrays.toString((char[])o);
                        }
                        if (type == Integer.TYPE) {
                            return Arrays.toString((int[])o);
                        }
                        if (type == Double.TYPE) {
                            return Arrays.toString((double[])o);
                        }
                        if (type == Long.TYPE) {
                            return Arrays.toString((long[])o);
                        }
                        if (type == Float.TYPE) {
                            return Arrays.toString((float[])o);
                        }
                        if (type == Short.TYPE) {
                            return Arrays.toString((short[])o);
                        }
                        if (type == Boolean.TYPE) {
                            return Arrays.toString((boolean[])o);
                        }
                        return "[Array of unknown primitive type: " + type + "]";
                    }
                    return Arrays.toString((Object[])o);
                }
                int max = Math.min(this.maxItems, Array.getLength(o));
                ArrayList<Object> list = new ArrayList<Object>(max);
                int i = 0;
                while (i < max) {
                    list.add(Array.get(o, i));
                    ++i;
                }
                if (max < Array.getLength(o)) {
                    list.add("(first " + max + '/' + Array.getLength(o) + " elements only...)");
                }
                o = list;
            } else if (o instanceof Collection && this.maxItems >= 0) {
                Collection coll = o;
                int max = Math.min(this.maxItems, coll.size());
                ArrayList<String> list = new ArrayList<String>(max);
                int i = 0;
                for (Object item : coll) {
                    if (i >= max) {
                        list.add("(first " + max + '/' + coll.size() + " elements only...)");
                        break;
                    }
                    list.add((String)item);
                    ++i;
                }
                o = list;
            } else if (o instanceof Map && this.maxItems >= 0) {
                Map map = (Map)((Object)o);
                int max = Math.min(this.maxItems, map.size());
                HashMap<String, String> copy = new HashMap<String, String>(max);
                int i = 0;
                for (Map.Entry item : map.entrySet()) {
                    if (i >= max) {
                        copy.put("(first " + max + '/' + map.size() + " elements only...)", "...");
                        break;
                    }
                    copy.put((String)item.getKey(), (String)item.getValue());
                    ++i;
                }
                o = copy;
            } else {
                o = ((Object)o).toString();
            }
            return o;
        }
        catch (Exception e) {
            return String.valueOf(o.getClass().getName()) + " (exception: " + e.toString() + ")";
        }
    }
}

