/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.amf.io.util.externalizer;

import java.beans.FeatureDescriptor;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.granite.collections.BasicMap;
import org.granite.context.GraniteContext;
import org.granite.logging.Logger;
import org.granite.messaging.amf.io.convert.Converters;
import org.granite.messaging.amf.io.util.FieldProperty;
import org.granite.messaging.amf.io.util.MethodProperty;
import org.granite.messaging.amf.io.util.Property;
import org.granite.messaging.amf.io.util.externalizer.DefaultConstructorFactory;
import org.granite.messaging.amf.io.util.externalizer.Externalizer;
import org.granite.messaging.amf.io.util.externalizer.NoDefaultConstructorFactory;
import org.granite.messaging.amf.io.util.externalizer.SunDefaultConstructorFactory;
import org.granite.messaging.amf.io.util.externalizer.annotation.ExternalizedBean;
import org.granite.messaging.amf.io.util.externalizer.annotation.ExternalizedProperty;
import org.granite.messaging.amf.io.util.instanciator.AbstractInstanciator;
import org.granite.util.ClassUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultExternalizer
implements Externalizer {
    private static final Logger log = Logger.getLogger(DefaultExternalizer.class);
    private final ReentrantLock lock = new ReentrantLock();
    private final ConcurrentHashMap<Class<?>, List<Property>> orderedFields = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Constructor<?>> constructors = new ConcurrentHashMap();

    @Override
    public Object newInstance(String type, ObjectInput in) throws IOException, ClassNotFoundException, InstantiationException, InvocationTargetException, IllegalAccessException {
        Class<?> clazz;
        Constructor<?> previousConstructor;
        Constructor<?> constructor = this.constructors.get(type);
        if (constructor == null && (previousConstructor = this.constructors.putIfAbsent(type, constructor = this.findDefaultConstructor(clazz = ClassUtil.forName(type)))) != null) {
            constructor = previousConstructor;
        }
        return constructor.newInstance(new Object[0]);
    }

    @Override
    public void readExternal(Object o, ObjectInput in) throws IOException, ClassNotFoundException, IllegalAccessException {
        if (o instanceof AbstractInstanciator) {
            AbstractInstanciator instanciator = (AbstractInstanciator)o;
            List<String> fields = instanciator.getOrderedFieldNames();
            log.debug("Reading bean with instanciator %s with fields %s", instanciator.getClass().getName(), fields);
            for (String fieldName : fields) {
                instanciator.put(fieldName, in.readObject());
            }
        } else {
            List<Property> fields = this.findOrderedFields(o.getClass());
            log.debug("Reading bean %s with fields %s", o.getClass().getName(), fields);
            for (Property field : fields) {
                if (field instanceof MethodProperty && field.isAnnotationPresent(ExternalizedProperty.class)) continue;
                Object value = in.readObject();
                field.setProperty(o, value);
            }
        }
    }

    @Override
    public void writeExternal(Object o, ObjectOutput out) throws IOException, IllegalAccessException {
        GraniteContext context = GraniteContext.getCurrentInstance();
        String instanciatorType = context.getGraniteConfig().getInstanciator(o.getClass().getName());
        if (instanciatorType != null) {
            try {
                AbstractInstanciator instanciator = (AbstractInstanciator)ClassUtil.newInstance(instanciatorType);
                List<String> fields = instanciator.getOrderedFieldNames();
                log.debug("Writing bean with instanciator %s with fields %s", instanciator.getClass().getName(), fields);
                for (String fieldName : fields) {
                    Field field = o.getClass().getDeclaredField(fieldName);
                    field.setAccessible(true);
                    out.writeObject(field.get(o));
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Error with instanciatorType: " + instanciatorType, e);
            }
        } else {
            List<Property> fields = this.findOrderedFields(o.getClass());
            log.debug("Writing bean %s with fields %s", o.getClass().getName(), fields);
            for (Property field : fields) {
                BasicMap<?, ?> value = field.getProperty(o);
                if (value instanceof Map) {
                    value = BasicMap.newInstance((Map)value);
                }
                out.writeObject(value);
            }
        }
    }

    @Override
    public List<Property> findOrderedFields(Class<?> clazz) {
        List<Property> fields = this.orderedFields.get(clazz);
        if (fields == null) {
            PropertyDescriptor[] propertyDescriptors = ClassUtil.getProperties(clazz);
            Converters converters = GraniteContext.getCurrentInstance().getGraniteConfig().getConverters();
            fields = new ArrayList<Property>();
            HashSet<String> allFieldNames = new HashSet<String>();
            Class<?> c = clazz;
            while (c != null) {
                ArrayList<Property> newFields = new ArrayList<Property>();
                Object[] objectArray = c.getDeclaredFields();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Field field = objectArray[n2];
                    if (!(allFieldNames.contains(field.getName()) || Modifier.isTransient(field.getModifiers()) || Modifier.isStatic(field.getModifiers()))) {
                        newFields.add(new FieldProperty(converters, field));
                    }
                    allFieldNames.add(field.getName());
                    ++n2;
                }
                if (propertyDescriptors != null) {
                    objectArray = propertyDescriptors;
                    n = propertyDescriptors.length;
                    n2 = 0;
                    while (n2 < n) {
                        Object property = objectArray[n2];
                        Method getter = ((PropertyDescriptor)property).getReadMethod();
                        if (getter != null && getter.isAnnotationPresent(ExternalizedProperty.class) && getter.getDeclaringClass().equals(c) && !allFieldNames.contains(((FeatureDescriptor)property).getName())) {
                            newFields.add(new MethodProperty(converters, ((FeatureDescriptor)property).getName(), null, getter));
                            allFieldNames.add(((FeatureDescriptor)property).getName());
                        }
                        ++n2;
                    }
                }
                Collections.sort(newFields, new Comparator<Property>(){

                    @Override
                    public int compare(Property o1, Property o2) {
                        return o1.getName().compareTo(o2.getName());
                    }
                });
                fields.addAll(0, newFields);
                c = c.getSuperclass();
            }
            List<Property> previousFields = this.orderedFields.putIfAbsent(clazz, fields);
            if (previousFields != null) {
                fields = previousFields;
            }
        }
        return fields;
    }

    protected <T> Constructor<T> findDefaultConstructor(Class<T> clazz) {
        Constructor<T> constructor = null;
        GraniteContext context = GraniteContext.getCurrentInstance();
        String instanciator = context.getGraniteConfig().getInstanciator(clazz.getName());
        if (instanciator != null) {
            try {
                Class<T> instanciatorClass = ClassUtil.forName(instanciator, clazz);
                constructor = instanciatorClass.getConstructor(new Class[0]);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Could not load instanciator class: " + instanciator + " for: " + clazz.getName(), e);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("Could not find default constructor in instanciator class: " + instanciator, e);
            }
        }
        try {
            constructor = clazz.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        if (constructor == null) {
            String key = DefaultConstructorFactory.class.getName();
            DefaultConstructorFactory factory = this.getDefaultConstructorFactory(context, key);
            constructor = factory.findDefaultConstructor(clazz);
        }
        return constructor;
    }

    private DefaultConstructorFactory getDefaultConstructorFactory(GraniteContext context, String key) {
        this.lock.lock();
        try {
            DefaultConstructorFactory factory = (DefaultConstructorFactory)context.getApplicationMap().get(key);
            if (factory == null) {
                try {
                    factory = new SunDefaultConstructorFactory();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (factory == null) {
                    factory = new NoDefaultConstructorFactory();
                }
                context.getApplicationMap().put(key, factory);
            }
            DefaultConstructorFactory defaultConstructorFactory = factory;
            return defaultConstructorFactory;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int accept(Class<?> clazz) {
        return clazz.isAnnotationPresent(ExternalizedBean.class) ? 0 : -1;
    }
}

