/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.service;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.ejb.Remove;
import javax.ejb.Stateful;
import org.granite.messaging.service.ServiceException;
import org.granite.util.ClassUtil;
import org.granite.util.StringUtil;
import org.granite.util.XMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EjbServiceMetadata
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final boolean stateful;
    private final Map<Method, Boolean> removeMethods;

    public EjbServiceMetadata(Class<?> scannedClass, Class<?> invokeeClass) {
        this.stateful = scannedClass.isAnnotationPresent(Stateful.class);
        HashMap<Method, Boolean> tmp = new HashMap<Method, Boolean>();
        if (this.stateful) {
            Method[] methodArray = scannedClass.getMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                Remove remove = method.getAnnotation(Remove.class);
                if (remove != null) {
                    try {
                        method = invokeeClass.getMethod(method.getName(), method.getParameterTypes());
                        tmp.put(method, remove.retainIfException());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ++n2;
            }
        }
        this.removeMethods = Collections.unmodifiableMap(tmp);
    }

    public EjbServiceMetadata(XMap properties, Class<?> invokeeClass) {
        this.stateful = properties.containsKey("ejb-stateful");
        HashMap<Method, Boolean> tmp = new HashMap<Method, Boolean>();
        if (this.stateful) {
            for (XMap removeMethod : properties.getAll("ejb-stateful/remove-method")) {
                String signature = StringUtil.removeSpaces(removeMethod.get("signature"));
                if (signature == null) {
                    throw new ServiceException("Missing signature in remove-method declaration: " + properties);
                }
                if (!signature.endsWith(")")) {
                    signature = String.valueOf(signature) + "()";
                }
                Boolean retainIfException = Boolean.valueOf(removeMethod.get("retain-if-exception"));
                boolean found = false;
                Method[] methodArray = invokeeClass.getMethods();
                int n = methodArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Method method = methodArray[n2];
                    if (signature.equals(ClassUtil.getMethodSignature(method))) {
                        tmp.put(method, retainIfException);
                        found = true;
                        break;
                    }
                    ++n2;
                }
                if (found) continue;
                throw new ServiceException("Could not find method: " + invokeeClass.getName() + "." + signature);
            }
        }
        this.removeMethods = Collections.unmodifiableMap(tmp);
    }

    public boolean isStateful() {
        return this.stateful;
    }

    public boolean isRemoveMethod(Method method) {
        return this.removeMethods.containsKey(method);
    }

    public boolean getRetainIfException(Method method) {
        return this.removeMethods.get(method);
    }
}

