/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.webapp;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.granite.config.GraniteConfig;
import org.granite.config.flex.ServicesConfig;
import org.granite.context.AMFContextImpl;
import org.granite.context.GraniteContext;
import org.granite.logging.Logger;
import org.granite.messaging.amf.AMF0Message;
import org.granite.messaging.amf.io.AMF0Deserializer;
import org.granite.messaging.amf.io.AMF0Serializer;
import org.granite.messaging.webapp.HttpGraniteContext;

public class AMFMessageFilter
implements Filter {
    private static final Logger log = Logger.getLogger(AMFMessageFilter.class);
    private FilterConfig config = null;
    private GraniteConfig graniteConfig = null;
    private ServicesConfig servicesConfig = null;

    public void init(FilterConfig config) throws ServletException {
        this.config = config;
        this.graniteConfig = GraniteConfig.loadConfig(config.getServletContext());
        this.servicesConfig = ServicesConfig.loadConfig(config.getServletContext());
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!(request instanceof HttpServletRequest) || !(response instanceof HttpServletResponse)) {
            throw new ServletException("Not in HTTP context: " + request + ", " + response);
        }
        log.debug(">> Incoming AMF0 request from: %s", ((HttpServletRequest)request).getRequestURL());
        try {
            try {
                HttpGraniteContext context = HttpGraniteContext.createThreadIntance(this.graniteConfig, this.servicesConfig, this.config.getServletContext(), (HttpServletRequest)request, (HttpServletResponse)response);
                AMFContextImpl amf = (AMFContextImpl)context.getAMFContext();
                log.debug(">> Deserializing AMF0 request...", new Object[0]);
                AMF0Deserializer deserializer = new AMF0Deserializer(new DataInputStream((InputStream)request.getInputStream()));
                AMF0Message amf0Request = deserializer.getAMFMessage();
                amf.setAmf0Request(amf0Request);
                log.debug(">> Chaining AMF0 request: %s", amf0Request);
                chain.doFilter(request, response);
                AMF0Message amf0Response = amf.getAmf0Response();
                log.debug("<< Serializing AMF0 response: %s", amf0Response);
                response.setContentType("application/x-amf");
                AMF0Serializer serializer = new AMF0Serializer(new DataOutputStream((OutputStream)response.getOutputStream()));
                serializer.serializeMessage(amf0Response);
            }
            catch (IOException e) {
                log.error(e, "AMF message error", new Object[0]);
                throw e;
            }
            catch (Exception e) {
                log.error(e, "AMF message error", new Object[0]);
                throw new ServletException((Throwable)e);
            }
        }
        finally {
            GraniteContext.release();
        }
    }

    public void destroy() {
        this.config = null;
        this.graniteConfig = null;
        this.servicesConfig = null;
    }
}

