/*
 * Decompiled with CFR 0.152.
 */
package org.granite.config;

import java.util.List;
import java.util.Map;
import org.granite.config.GraniteConfigException;
import org.granite.messaging.service.tide.TideComponentAnnotatedWithMatcher;
import org.granite.messaging.service.tide.TideComponentInstanceOfMatcher;
import org.granite.messaging.service.tide.TideComponentMatcher;
import org.granite.messaging.service.tide.TideComponentNameMatcher;
import org.granite.messaging.service.tide.TideComponentTypeMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TideComponentMatcherFactory {
    public TideComponentMatcher getTypeMatcher(String type, boolean disabled) throws GraniteConfigException {
        try {
            return new TideComponentTypeMatcher(type, disabled);
        }
        catch (Exception e) {
            throw new GraniteConfigException("Could not instantiate Tide component matcher for type: " + type, e);
        }
    }

    public TideComponentMatcher getNameMatcher(String name, boolean disabled) throws GraniteConfigException {
        try {
            return new TideComponentNameMatcher(name, disabled);
        }
        catch (Exception e) {
            throw new GraniteConfigException("Could not instantiate Tide component matcher for name: " + name, e);
        }
    }

    public TideComponentMatcher getInstanceOfMatcher(String type, boolean disabled) throws GraniteConfigException {
        try {
            return new TideComponentInstanceOfMatcher(type, disabled);
        }
        catch (Exception e) {
            throw new GraniteConfigException("Could not instantiate Tide component matcher for instance of: " + type, e);
        }
    }

    public TideComponentMatcher getAnnotatedWithMatcher(String type, boolean disabled) throws GraniteConfigException {
        try {
            return new TideComponentAnnotatedWithMatcher(type, disabled);
        }
        catch (Exception e) {
            throw new GraniteConfigException("Could not instantiate Tide component matcher for annotated with: " + type, e);
        }
    }

    public static boolean isComponentTideEnabled(Map<String, Boolean> tideComponentsByName, List<TideComponentMatcher> tideComponentMatchers, String componentName, Class<?> componentClass, Object componentInstance) throws GraniteConfigException {
        if (tideComponentsByName.containsKey(componentName)) {
            return tideComponentsByName.get(componentName);
        }
        boolean enabled = false;
        for (TideComponentMatcher matcher : tideComponentMatchers) {
            if (!matcher.matches(componentName, componentClass, componentInstance, false)) continue;
            enabled = true;
            break;
        }
        tideComponentsByName.put(componentName, enabled);
        return enabled;
    }

    public static boolean isComponentTideDisabled(Map<String, Boolean> tideComponentsByName, List<TideComponentMatcher> tideComponentMatchers, String componentName, Class<?> componentClass, Object componentInstance) throws GraniteConfigException {
        if (tideComponentsByName.containsKey(componentName)) {
            return tideComponentsByName.get(componentName);
        }
        boolean disabled = false;
        for (TideComponentMatcher matcher : tideComponentMatchers) {
            if (!matcher.matches(componentName, componentClass, componentInstance, true)) continue;
            disabled = true;
            break;
        }
        tideComponentsByName.put(componentName, disabled);
        return disabled;
    }
}

