/*
 * Decompiled with CFR 0.152.
 */
package org.granite.config.flex;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.granite.config.GraniteConfig;
import org.granite.config.flex.Channel;
import org.granite.config.flex.Destination;
import org.granite.config.flex.EndPoint;
import org.granite.config.flex.Factory;
import org.granite.config.flex.Service;
import org.granite.logging.Logger;
import org.granite.messaging.service.annotations.RemoteDestination;
import org.granite.scan.ScannedItem;
import org.granite.scan.ScannedItemHandler;
import org.granite.scan.Scanner;
import org.granite.util.XMap;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServicesConfig
implements ScannedItemHandler {
    private static final Logger log = Logger.getLogger(ServicesConfig.class);
    private static final String SERVICES_CONFIG_KEY = String.valueOf(ServicesConfig.class.getName()) + "_CACHE";
    private static final String SERVICES_CONFIG_PROPERTIES = "META-INF/services-config.properties";
    private final Map<String, Service> services = new HashMap<String, Service>();
    private final Map<String, Channel> channels = new HashMap<String, Channel>();
    private final Map<String, Factory> factories = new HashMap<String, Factory>();

    private void scanConfig() {
        Scanner scanner = new Scanner((ScannedItemHandler)this, SERVICES_CONFIG_PROPERTIES);
        try {
            scanner.scan();
        }
        catch (Exception e) {
            log.error(e, "Could not scan classpath for configuration", new Object[0]);
        }
    }

    @Override
    public void handleMarkerItem(ScannedItem item) {
    }

    @Override
    public void handleScannedItem(ScannedItem item) {
        if ("class".equals(item.getExtension()) && item.getName().indexOf(36) == -1) {
            try {
                this.handleClass(item.loadAsClass());
            }
            catch (Throwable t) {
                log.error(t, "Could not load class: %s", item);
            }
        }
    }

    private void handleClass(Class<?> clazz) {
        RemoteDestination anno = clazz.getAnnotation(RemoteDestination.class);
        if (anno != null) {
            XMap props = new XMap("properties");
            Service service = null;
            if (anno.service().length() > 0) {
                service = this.services.get(anno.service());
            } else if (this.services.size() > 0) {
                int count = 0;
                for (Service s : this.services.values()) {
                    if (!"flex.messaging.messages.RemotingMessage".equals(s.getMessageTypes())) continue;
                    service = s;
                    ++count;
                }
                if (count == 1) {
                    service = this.services.values().iterator().next();
                    log.info("Service " + service.getId() + " selected for destination in class: " + clazz.getName(), new Object[0]);
                }
            }
            if (service == null) {
                throw new RuntimeException("No service found for destination in class: " + clazz.getName());
            }
            List<String> channelIds = null;
            if (anno.channels().length > 0) {
                channelIds = Arrays.asList(anno.channels());
            } else if (anno.channel().length() > 0) {
                channelIds = Collections.singletonList(anno.channel());
            } else if (this.channels.size() == 1) {
                channelIds = new ArrayList<String>((Collection)this.channels.keySet());
                log.info("Channel " + channelIds.get(0) + " selected for destination in class: " + clazz.getName(), new Object[0]);
            } else {
                throw new RuntimeException("No (or ambiguous) channel definition found for destination in class: " + clazz.getName());
            }
            String factoryId = null;
            if (anno.factory().length() > 0) {
                factoryId = anno.factory();
            } else if (this.factories.isEmpty()) {
                props.put("scope", anno.scope());
                props.put("source", clazz.getName());
                log.info("Default POJO factory selected for destination in class: " + clazz.getName() + " with scope: " + anno.scope(), new Object[0]);
            } else if (this.factories.size() == 1) {
                factoryId = this.factories.keySet().iterator().next();
                log.info("Factory " + factoryId + " selected for destination in class: " + clazz.getName(), new Object[0]);
            } else {
                throw new RuntimeException("No (or ambiguous) factory definition found for destination in class: " + clazz.getName());
            }
            if (factoryId != null) {
                props.put("factory", factoryId);
            }
            if (!anno.source().equals("")) {
                props.put("source", anno.source());
            }
            List<String> roles = anno.securityRoles().length > 0 ? Arrays.asList(anno.securityRoles()) : null;
            Destination destination = new Destination(anno.id(), channelIds, props, roles, null, clazz);
            service.getDestinations().put(destination.getId(), destination);
        }
    }

    public static synchronized ServicesConfig loadConfig(ServletContext context) throws ServletException {
        ServicesConfig servicesConfig = (ServicesConfig)context.getAttribute(SERVICES_CONFIG_KEY);
        if (servicesConfig == null) {
            InputStream is;
            String path = context.getInitParameter("servicesConfigPath");
            if (path == null) {
                path = "/WEB-INF/flex/services-config.xml";
            }
            if ((is = context.getResourceAsStream(path)) == null) {
                throw new ServletException("Could not load: " + path + " (file does not exists)");
            }
            try {
                servicesConfig = ServicesConfig.loadConfig(is);
            }
            catch (Exception e) {
                throw new ServletException("Could not load custom granite-config.xml", (Throwable)e);
            }
            GraniteConfig graniteConfig = GraniteConfig.loadConfig(context);
            if (graniteConfig.getScan()) {
                servicesConfig.scanConfig();
            }
            context.setAttribute(SERVICES_CONFIG_KEY, (Object)servicesConfig);
        }
        return servicesConfig;
    }

    public static ServicesConfig loadConfig(InputStream configIs) throws IOException, SAXException {
        XMap doc = new XMap(configIs);
        return ServicesConfig.forElement(doc);
    }

    public Service findServiceById(String id) {
        return this.services.get(id);
    }

    public List<Service> findServicesByMessageType(String messageType) {
        ArrayList<Service> services = new ArrayList<Service>();
        for (Service service : services) {
            if (!messageType.equals(service.getMessageTypes())) continue;
            services.add(service);
        }
        return services;
    }

    public void addService(Service service) {
        this.services.put(service.getId(), service);
    }

    public Channel findChannelById(String id) {
        return this.channels.get(id);
    }

    public void addChannel(Channel channel) {
        this.channels.put(channel.getId(), channel);
    }

    public Factory findFactoryById(String id) {
        return this.factories.get(id);
    }

    public void addFactory(Factory factory) {
        this.factories.put(factory.getId(), factory);
    }

    public Destination findDestinationById(String messageType, String id) {
        for (Service service : this.services.values()) {
            Destination destination;
            if (messageType != null && !messageType.equals(service.getMessageTypes()) || (destination = service.findDestinationById(id)) == null) continue;
            return destination;
        }
        return null;
    }

    public List<Destination> findDestinationsByMessageType(String messageType) {
        ArrayList<Destination> destinations = new ArrayList<Destination>();
        for (Service service : this.services.values()) {
            if (!messageType.equals(service.getMessageTypes())) continue;
            destinations.addAll(service.getDestinations().values());
        }
        return destinations;
    }

    private static ServicesConfig forElement(XMap element) {
        XMap channels;
        ServicesConfig config = new ServicesConfig();
        XMap services = element.getOne("services");
        if (services != null) {
            for (XMap service : services.getAll("service")) {
                Service serv = Service.forElement(service);
                config.services.put(serv.getId(), serv);
            }
        }
        if ((channels = element.getOne("channels")) != null) {
            for (XMap channel : channels.getAll("channel-definition")) {
                Channel chan = Channel.forElement(channel);
                config.channels.put(chan.getId(), chan);
            }
        } else {
            log.info("No channel definition found, using defaults", new Object[0]);
            EndPoint defaultEndpoint = new EndPoint("http://{server.name}:{server.port}/{context.root}/graniteamf/amf", "flex.messaging.endpoints.AMFEndpoint");
            Channel defaultChannel = new Channel("my-graniteamf", "mx.messaging.channels.AMFChannel", defaultEndpoint, XMap.EMPTY_XMAP);
            config.channels.put(defaultChannel.getId(), defaultChannel);
        }
        XMap factories = element.getOne("factories");
        if (factories != null) {
            for (XMap factory : factories.getAll("factory")) {
                Factory fact = Factory.forElement(factory);
                config.factories.put(fact.getId(), fact);
            }
        }
        return config;
    }
}

