/*
 * Decompiled with CFR 0.152.
 */
package org.granite.logging;

import org.granite.logging.Level;
import org.granite.logging.Logger;
import org.granite.logging.LoggingFormatter;

public class JdkLogger
extends Logger {
    public JdkLogger(String name, LoggingFormatter formatter) {
        super(java.util.logging.Logger.getLogger(name), formatter);
    }

    protected java.util.logging.Logger getLoggerImpl() {
        return (java.util.logging.Logger)super.getLoggerImpl();
    }

    public void info(String message, Object ... args) {
        if (this.isInfoEnabled()) {
            this.getLoggerImpl().log(java.util.logging.Level.INFO, this.getFormatter().format(message, args));
        }
    }

    public void info(Throwable t, String message, Object ... args) {
        if (this.isInfoEnabled()) {
            this.getLoggerImpl().log(java.util.logging.Level.INFO, this.getFormatter().format(message, args), t);
        }
    }

    public void trace(String message, Object ... args) {
        if (this.isTraceEnabled()) {
            this.getLoggerImpl().log(java.util.logging.Level.FINE, this.getFormatter().format(message, args));
        }
    }

    public void trace(Throwable t, String message, Object ... args) {
        if (this.isTraceEnabled()) {
            this.getLoggerImpl().log(java.util.logging.Level.FINE, this.getFormatter().format(message, args), t);
        }
    }

    public void warn(String message, Object ... args) {
        if (this.isWarnEnabled()) {
            this.getLoggerImpl().log(java.util.logging.Level.WARNING, this.getFormatter().format(message, args));
        }
    }

    public void warn(Throwable t, String message, Object ... args) {
        if (this.isWarnEnabled()) {
            this.getLoggerImpl().log(java.util.logging.Level.WARNING, this.getFormatter().format(message, args), t);
        }
    }

    public void debug(String message, Object ... args) {
        if (this.isDebugEnabled()) {
            this.getLoggerImpl().log(java.util.logging.Level.FINER, this.getFormatter().format(message, args));
        }
    }

    public void debug(Throwable t, String message, Object ... args) {
        if (this.isDebugEnabled()) {
            this.getLoggerImpl().log(java.util.logging.Level.FINER, this.getFormatter().format(message, args), t);
        }
    }

    public void error(String message, Object ... args) {
        if (this.isErrorEnabled()) {
            this.getLoggerImpl().log(java.util.logging.Level.SEVERE, this.getFormatter().format(message, args));
        }
    }

    public void error(Throwable t, String message, Object ... args) {
        if (this.isErrorEnabled()) {
            this.getLoggerImpl().log(java.util.logging.Level.SEVERE, this.getFormatter().format(message, args), t);
        }
    }

    public void fatal(String message, Object ... args) {
        if (this.isFatalEnabled()) {
            this.getLoggerImpl().log(java.util.logging.Level.SEVERE, this.getFormatter().format(message, args));
        }
    }

    public void fatal(Throwable t, String message, Object ... args) {
        if (this.isFatalEnabled()) {
            this.getLoggerImpl().log(java.util.logging.Level.SEVERE, this.getFormatter().format(message, args), t);
        }
    }

    public void setLevel(Level level) {
        java.util.logging.Level jdkLevel = null;
        switch (level) {
            case FATAL: {
                jdkLevel = java.util.logging.Level.SEVERE;
                break;
            }
            case ERROR: {
                jdkLevel = java.util.logging.Level.SEVERE;
                break;
            }
            case INFO: {
                jdkLevel = java.util.logging.Level.INFO;
                break;
            }
            case TRACE: {
                jdkLevel = java.util.logging.Level.FINER;
                break;
            }
            case DEBUG: {
                jdkLevel = java.util.logging.Level.FINE;
                break;
            }
            case WARN: {
                jdkLevel = java.util.logging.Level.WARNING;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown logging level: " + (Object)((Object)level));
            }
        }
        this.getLoggerImpl().setLevel(jdkLevel);
    }

    public boolean isDebugEnabled() {
        return this.getLoggerImpl().isLoggable(java.util.logging.Level.FINE);
    }

    public boolean isErrorEnabled() {
        return this.getLoggerImpl().isLoggable(java.util.logging.Level.SEVERE);
    }

    public boolean isFatalEnabled() {
        return this.getLoggerImpl().isLoggable(java.util.logging.Level.SEVERE);
    }

    public boolean isInfoEnabled() {
        return this.getLoggerImpl().isLoggable(java.util.logging.Level.INFO);
    }

    public boolean isTraceEnabled() {
        return this.getLoggerImpl().isLoggable(java.util.logging.Level.FINER);
    }

    public boolean isWarnEnabled() {
        return this.getLoggerImpl().isLoggable(java.util.logging.Level.WARNING);
    }
}

