/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.amf.io.util.instanciator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.granite.messaging.amf.io.util.instanciator.AbstractInstanciator;
import org.granite.messaging.service.ServiceException;
import org.granite.util.ClassUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumInstanciator
extends AbstractInstanciator<Enum<?>> {
    private static final long serialVersionUID = -6116814787518316453L;
    private final String type;
    private static final List<String> orderedFields;

    static {
        ArrayList<String> of = new ArrayList<String>(1);
        of.add("value");
        orderedFields = Collections.unmodifiableList(of);
    }

    public EnumInstanciator(String type) {
        this.type = type;
    }

    @Override
    public List<String> getOrderedFieldNames() {
        return orderedFields;
    }

    @Override
    public Enum<?> newInstance() {
        Enum<?> enumInstance = null;
        String enumValue = null;
        try {
            Class<?> enumClass = ClassUtil.forName(this.type);
            enumValue = (String)this.get("value");
            if (enumValue == null) {
                ?[] enumConstants = enumClass.getEnumConstants();
                if (enumConstants == null || enumConstants.length == 0) {
                    throw new ServiceException("Invalid Enum type: " + this.type);
                }
                enumValue = ((Enum)enumConstants[0]).name();
            }
            enumInstance = (Enum<?>)Enum.valueOf(enumClass, enumValue);
        }
        catch (ClassNotFoundException e) {
            throw new ServiceException("Could not find Enum type for: " + this.type, e);
        }
        catch (IllegalArgumentException e) {
            throw new ServiceException("Could not find Enum constant for: " + this.type + '.' + enumValue, e);
        }
        return enumInstance;
    }
}

