/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.service;

import flex.messaging.messages.Message;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import org.granite.config.GraniteConfig;
import org.granite.config.flex.Destination;
import org.granite.context.GraniteContext;
import org.granite.messaging.amf.io.convert.Converter;
import org.granite.messaging.amf.io.convert.Converters;
import org.granite.messaging.service.MethodMatcher;
import org.granite.messaging.service.ServiceInvocationContext;
import org.granite.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMethodMatcher
implements MethodMatcher {
    @Override
    public ServiceInvocationContext findServiceMethod(Message message, Destination destination, Object service, String methodName, Object[] params) throws NoSuchMethodException {
        GraniteConfig config = GraniteContext.getCurrentInstance().getGraniteConfig();
        Converters converters = config.getConverters();
        Class<?> serviceClass = service.getClass();
        Type serviceClassGenericType = this.getGenericType(serviceClass);
        Converter[] convertersArray = null;
        Method serviceMethod = null;
        if (params == null || params.length == 0) {
            serviceMethod = serviceClass.getMethod(methodName, null);
        } else {
            Method[] methodArray = serviceClass.getMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                Type[] paramTypes;
                Method method = methodArray[n2];
                if (methodName.equals(method.getName()) && (paramTypes = method.getGenericParameterTypes()).length == params.length) {
                    if (serviceClassGenericType != null) {
                        this.findAndChange(paramTypes, serviceClassGenericType);
                    }
                    if ((convertersArray = this.getConvertersArray(converters, params, paramTypes)) != null) {
                        serviceMethod = method;
                        break;
                    }
                }
                ++n2;
            }
        }
        if (serviceMethod == null) {
            throw new NoSuchMethodException(String.valueOf(serviceClass.getName()) + '.' + methodName + StringUtil.toString(params));
        }
        params = this.convert(convertersArray, params, serviceMethod.getGenericParameterTypes());
        return new ServiceInvocationContext(message, destination, service, serviceMethod, params);
    }

    protected Converter[] getConvertersArray(Converters converters, Object[] values, Type[] targetTypes) {
        Converter[] convertersArray = new Converter[values.length];
        int i = 0;
        while (i < values.length) {
            convertersArray[i] = converters.getConverter(values[i], targetTypes[i]);
            if (convertersArray[i] == null) {
                return null;
            }
            ++i;
        }
        return convertersArray;
    }

    protected Object[] convert(Converter[] convertersArray, Object[] values, Type[] targetTypes) {
        if (values.length > 0) {
            int i = 0;
            while (i < convertersArray.length) {
                values[i] = convertersArray[i].convert(values[i], targetTypes[i]);
                ++i;
            }
        }
        return values;
    }

    protected boolean findAndChange(Type[] paramTypes, Type superType) {
        int idx = -1;
        boolean find = false;
        int j = 0;
        while (j < paramTypes.length) {
            Type type = paramTypes[j];
            if (type instanceof TypeVariable) {
                if (!find) {
                    idx = j;
                    find = true;
                } else {
                    throw new RuntimeException("There's two variable types.");
                }
            }
            ++j;
        }
        if (find) {
            paramTypes[idx] = superType;
        }
        return find;
    }

    protected Type getGenericType(Class<?> clazz) {
        try {
            ParameterizedType genericSuperclass = (ParameterizedType)clazz.getGenericSuperclass();
            Type[] actualTypeArguments = genericSuperclass.getActualTypeArguments();
            if (actualTypeArguments != null && actualTypeArguments.length == 1) {
                return actualTypeArguments[0];
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

