/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.service.security;

import java.lang.reflect.InvocationTargetException;
import java.security.Principal;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.granite.context.GraniteContext;
import org.granite.messaging.service.security.AbstractSecurityContext;
import org.granite.messaging.service.security.AbstractSecurityService;
import org.granite.messaging.service.security.SecurityServiceException;
import org.granite.messaging.webapp.HttpGraniteContext;
import org.mortbay.jetty.HttpConnection;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.security.UserRealm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Jetty6SecurityService
extends AbstractSecurityService {
    private static final String JETTY6_AUTH = "org.granite.messaging.service.security.Jetty6Auth";

    @Override
    public void configure(Map<String, String> params) {
    }

    @Override
    public void login(Object credentials) throws SecurityServiceException {
        String[] decoded = this.decodeBase64Credentials(credentials);
        HttpGraniteContext graniteContext = (HttpGraniteContext)GraniteContext.getCurrentInstance();
        HttpServletRequest httpRequest = graniteContext.getRequest();
        Request request = httpRequest instanceof Request ? (Request)httpRequest : HttpConnection.getCurrentConnection().getRequest();
        UserRealm realm = request.getUserRealm();
        Principal principal = realm.authenticate(decoded[0], (Object)decoded[1], request);
        if (principal == null) {
            throw SecurityServiceException.newInvalidCredentialsException("Wrong username or password");
        }
        request.setAuthType("granite-security");
        request.setUserPrincipal(principal);
        request.getSession().setAttribute(JETTY6_AUTH, (Object)principal);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public Object authorize(AbstractSecurityContext context) throws Exception {
        this.startAuthorization(context);
        graniteContext = (HttpGraniteContext)GraniteContext.getCurrentInstance();
        httpRequest = graniteContext.getRequest();
        reauth = false;
        principal = httpRequest.getUserPrincipal();
        if (principal == null) {
            session = httpRequest.getSession(false);
            principal = session != null ? (Principal)session.getAttribute("org.granite.messaging.service.security.Jetty6Auth") : null;
            reauth = true;
        }
        if (principal == null) {
            if (httpRequest.getRequestedSessionId() != null && ((httpSession = httpRequest.getSession(false)) == null || httpRequest.getRequestedSessionId().equals(httpSession.getId()))) {
                throw SecurityServiceException.newSessionExpiredException("Session expired");
            }
            throw SecurityServiceException.newNotLoggedInException("User not logged in");
        }
        request = httpRequest instanceof Request != false ? (Request)httpRequest : HttpConnection.getCurrentConnection().getRequest();
        realm = request.getUserRealm();
        if (reauth) {
            realm.reauthenticate(principal);
        }
        if (context.getDestination().isSecured()) {
            accessDenied = true;
            for (String role : context.getDestination().getRoles()) {
                if (!realm.isUserInRole(principal, role)) continue;
                accessDenied = false;
                break;
            }
            if (accessDenied) {
                throw SecurityServiceException.newAccessDeniedException("User not in required role");
            }
            request.setAuthType("granite-security");
            request.setUserPrincipal(principal);
        }
        try {
            return this.endAuthorization(context);
        }
        catch (InvocationTargetException e) {
            t /* !! */  = e;
            ** while (t /* !! */  != null)
        }
lbl-1000:
        // 1 sources

        {
            if (t /* !! */  instanceof SecurityException) {
                throw SecurityServiceException.newAccessDeniedException(t /* !! */ .getMessage());
            }
            t /* !! */  = t /* !! */ .getCause();
            continue;
        }
lbl38:
        // 1 sources

        throw e;
    }

    @Override
    public void logout() throws SecurityServiceException {
        HttpGraniteContext graniteContext = (HttpGraniteContext)GraniteContext.getCurrentInstance();
        HttpServletRequest httpRequest = graniteContext.getRequest();
        Request request = httpRequest instanceof Request ? (Request)httpRequest : HttpConnection.getCurrentConnection().getRequest();
        UserRealm realm = request.getUserRealm();
        realm.disassociate(httpRequest.getUserPrincipal());
    }
}

