/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.webapp;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.granite.context.AMFContextImpl;
import org.granite.context.GraniteContext;
import org.granite.logging.Logger;
import org.granite.messaging.amf.AMF0Message;
import org.granite.messaging.amf.process.AMF0MessageProcessor;
import org.granite.messaging.webapp.AMFMessageFilter;

public class AMFMessageServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(AMFMessageServlet.class);

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            GraniteContext context = GraniteContext.getCurrentInstance();
            if (context == null) {
                throw new ServletException("No GraniteContext (" + AMFMessageFilter.class.getName() + " not configured in web.xml ?)");
            }
            AMFContextImpl amf = (AMFContextImpl)context.getAMFContext();
            AMF0Message amf0Request = amf.getAMF0Request();
            log.debug(">> Processing AMF0 request: %s", amf0Request);
            AMF0Message amf0Response = AMF0MessageProcessor.process(amf0Request);
            log.debug("<< Returning AMF0 response: %s", amf0Response);
            amf.setAmf0Response(amf0Response);
        }
        catch (Exception e) {
            log.error(e, "AMF message error", new Object[0]);
            throw new ServletException((Throwable)e);
        }
    }
}

