/*
 * Decompiled with CFR 0.152.
 */
package org.granite.scan;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.granite.scan.FileScannedItem;
import org.granite.scan.ScannedItemHandler;
import org.granite.scan.ZipScannedItem;

public class Scanner {
    private final ScannedItemHandler handler;
    private final String marker;
    private final URLClassLoader loader;

    public Scanner(ScannedItemHandler handler) {
        this(handler, null, (URLClassLoader)Thread.currentThread().getContextClassLoader());
    }

    public Scanner(ScannedItemHandler handler, String marker) {
        this(handler, marker, (URLClassLoader)Thread.currentThread().getContextClassLoader());
    }

    public Scanner(ScannedItemHandler handler, URLClassLoader loader) {
        this(handler, null, loader);
    }

    public Scanner(ScannedItemHandler handler, String marker, URLClassLoader loader) {
        this.marker = marker;
        this.handler = handler;
        this.loader = loader;
    }

    public String getMarker() {
        return this.marker;
    }

    public ScannedItemHandler getHandler() {
        return this.handler;
    }

    public URLClassLoader getLoader() {
        return this.loader;
    }

    public void scan() throws IOException {
        HashSet<String> paths = new HashSet<String>();
        if (this.marker == null) {
            URL[] uRLArray = this.loader.getURLs();
            int n = uRLArray.length;
            int n2 = 0;
            while (n2 < n) {
                URL url = uRLArray[n2];
                String urlPath = url.getFile();
                if (urlPath.endsWith("/")) {
                    urlPath = urlPath.substring(0, urlPath.length() - 1);
                }
                paths.add(urlPath);
                ++n2;
            }
        } else {
            Enumeration<URL> urlEnum = this.loader.getResources(this.marker);
            while (urlEnum.hasMoreElements()) {
                String urlPath = URLDecoder.decode(urlEnum.nextElement().getFile(), "UTF-8");
                if (urlPath.startsWith("file:")) {
                    urlPath = urlPath.substring(5);
                }
                if (urlPath.indexOf(33) > 0) {
                    urlPath = urlPath.substring(0, urlPath.indexOf(33));
                } else {
                    File dirOrArchive = new File(urlPath);
                    String[] tokens = this.marker.split("\\Q/\\E", -1);
                    int i = 0;
                    while (i < tokens.length) {
                        dirOrArchive = dirOrArchive.getParentFile();
                        ++i;
                    }
                    urlPath = dirOrArchive.getPath();
                }
                paths.add(urlPath);
            }
        }
        for (String urlPath : paths) {
            File file = new File(urlPath);
            if (file.isDirectory()) {
                this.handleDirectory(file, file);
                continue;
            }
            this.handleArchive(file);
        }
    }

    public void handleArchive(File file) throws ZipException, IOException {
        ZipFile zip = new ZipFile(file);
        ZipScannedItem markerItem = null;
        if (this.marker != null) {
            ZipEntry markerEntry = zip.getEntry(this.marker);
            markerItem = new ZipScannedItem(this, null, zip, markerEntry);
            this.handler.handleMarkerItem(markerItem);
        }
        Enumeration<? extends ZipEntry> entries = zip.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (entry.isDirectory() || markerItem != null && markerItem.getEntry().getName().equals(entry.getName())) continue;
            this.handler.handleScannedItem(new ZipScannedItem(this, markerItem, zip, entry));
        }
    }

    public void handleDirectory(File root, File path) {
        FileScannedItem markerItem = null;
        if (this.marker != null) {
            File markerFile = new File(root, this.marker);
            markerItem = new FileScannedItem(this, null, root, markerFile);
            this.handler.handleMarkerItem(markerItem);
        }
        this.handleDirectory(markerItem, root, path);
    }

    public void handleDirectory(FileScannedItem markerItem, File root, File path) {
        File[] fileArray = path.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File child = fileArray[n2];
            if (child.isDirectory()) {
                this.handleDirectory(markerItem, root, child);
            } else if (markerItem == null || !markerItem.getFile().equals(child)) {
                this.handler.handleScannedItem(new FileScannedItem(this, markerItem, root, child));
            }
            ++n2;
        }
    }
}

