/*
 * Decompiled with CFR 0.152.
 */
package org.granite.util;

import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class StringUtil {
    public static final String HEX_CHARS = "0123456789ABCDEF";

    public static String toHexString(Number n) {
        if (n == null) {
            return "null";
        }
        byte[] bytes = new byte[8];
        ByteBuffer bytesBuffer = ByteBuffer.wrap(bytes);
        LongBuffer longBuffer = bytesBuffer.asLongBuffer();
        longBuffer.put(0, n.longValue());
        StringBuilder sb = new StringBuilder(16);
        int i = 0;
        while (i < bytes.length) {
            int b = bytes[i] & 0xFF;
            if (b != 0 || sb.length() > 0 || i == bytes.length - 1) {
                sb.append(HEX_CHARS.charAt(b >> 4)).append(HEX_CHARS.charAt(b & 0xF));
            }
            ++i;
        }
        return sb.toString();
    }

    public static String removeSpaces(String s) {
        if (s == null) {
            return null;
        }
        String[] tokens = s.split("\\s", -1);
        if (tokens.length == 0) {
            return "";
        }
        if (tokens.length == 1) {
            return tokens[0];
        }
        StringBuilder sb = new StringBuilder();
        String[] stringArray = tokens;
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            String token = stringArray[n2];
            sb.append(token);
            ++n2;
        }
        return sb.toString();
    }

    public static String toString(Object o) {
        return StringUtil.toString(o, -1);
    }

    public static String toString(Object o, int maxItems) {
        if (o == null) {
            return "null";
        }
        if (o instanceof String) {
            return "\"" + o + "\"";
        }
        if (o instanceof Character || o.getClass() == Character.TYPE) {
            return "'" + o + "'";
        }
        if (o instanceof Number) {
            if (o instanceof Byte || o instanceof Short || o instanceof Integer || o instanceof Long) {
                return o + " <0x" + StringUtil.toHexString((Number)((Object)o)) + ">";
            }
            return String.valueOf(o);
        }
        try {
            if (o.getClass().isArray()) {
                Class<?> type = o.getClass().getComponentType();
                if (maxItems < 0) {
                    if (type.isPrimitive()) {
                        if (type == Byte.TYPE) {
                            return Arrays.toString((byte[])o);
                        }
                        if (type == Character.TYPE) {
                            return Arrays.toString((char[])o);
                        }
                        if (type == Integer.TYPE) {
                            return Arrays.toString((int[])o);
                        }
                        if (type == Double.TYPE) {
                            return Arrays.toString((double[])o);
                        }
                        if (type == Long.TYPE) {
                            return Arrays.toString((long[])o);
                        }
                        if (type == Float.TYPE) {
                            return Arrays.toString((float[])o);
                        }
                        if (type == Short.TYPE) {
                            return Arrays.toString((short[])o);
                        }
                        if (type == Boolean.TYPE) {
                            return Arrays.toString((boolean[])o);
                        }
                        return "[Array of unknown primitive type: " + type + "]";
                    }
                    return Arrays.toString((Object[])o);
                }
                int max = Math.min(maxItems, Array.getLength(o));
                ArrayList<Object> list = new ArrayList<Object>(max);
                int i = 0;
                while (i < max) {
                    list.add(Array.get(o, i));
                    ++i;
                }
                if (max < Array.getLength(o)) {
                    list.add("(first " + max + '/' + Array.getLength(o) + " elements only...)");
                }
                o = list;
            } else if (o instanceof Collection && maxItems >= 0) {
                Collection coll = o;
                int max = Math.min(maxItems, coll.size());
                ArrayList<String> list = new ArrayList<String>(max);
                int i = 0;
                for (Object item : coll) {
                    if (i >= max) {
                        list.add("(first " + max + '/' + coll.size() + " elements only...)");
                        break;
                    }
                    list.add((String)item);
                    ++i;
                }
                o = list;
            } else if (o instanceof Map && maxItems >= 0) {
                Map map = (Map)((Object)o);
                int max = Math.min(maxItems, map.size());
                HashMap<String, String> copy = new HashMap<String, String>(max);
                int i = 0;
                for (Map.Entry item : map.entrySet()) {
                    if (i >= max) {
                        copy.put("(first " + max + '/' + map.size() + " elements only...)", "...");
                        break;
                    }
                    copy.put((String)item.getKey(), (String)item.getValue());
                    ++i;
                }
                o = copy;
            }
            return String.valueOf(o);
        }
        catch (Exception e) {
            return String.valueOf(o.getClass().getName()) + " (exception: " + e.toString() + ")";
        }
    }
}

