/*
 * Decompiled with CFR 0.152.
 */
package org.granite.gravity.generic;

import org.granite.logging.Logger;

public class WaitingContinuation {
    private static final Logger log = Logger.getLogger(WaitingContinuation.class);
    Object _mutex;
    Object _object;
    boolean _new = true;
    boolean _resumed = false;
    boolean _pending = false;
    boolean _expired = false;

    public WaitingContinuation() {
        this._mutex = this;
    }

    public WaitingContinuation(Object mutex) {
        this._mutex = mutex == null ? this : mutex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        Object object = this._mutex;
        synchronized (object) {
            this._resumed = true;
            this._mutex.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Object object = this._mutex;
        synchronized (object) {
            this._resumed = false;
            this._pending = false;
            this._expired = false;
            this._mutex.notify();
        }
    }

    public boolean isNew() {
        return this._new;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean suspend(long timeout) {
        Object object = this._mutex;
        synchronized (object) {
            boolean result;
            block12: {
                this._new = false;
                this._pending = true;
                try {
                    try {
                        log.debug("Continuation suspend " + timeout, new Object[0]);
                        if (!this._resumed && timeout >= 0L) {
                            if (timeout == 0L) {
                                this._mutex.wait();
                            } else if (timeout > 0L) {
                                this._mutex.wait(timeout);
                            }
                        }
                    }
                    catch (InterruptedException e) {
                        this._expired = true;
                        log.debug("Continuation timeout", new Object[0]);
                        result = this._resumed;
                        this._resumed = false;
                        this._pending = false;
                        break block12;
                    }
                }
                catch (Throwable throwable) {
                    boolean result2 = this._resumed;
                    this._resumed = false;
                    this._pending = false;
                    throw throwable;
                }
                result = this._resumed;
                this._resumed = false;
                this._pending = false;
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPending() {
        Object object = this._mutex;
        synchronized (object) {
            return this._pending;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isResumed() {
        Object object = this._mutex;
        synchronized (object) {
            return this._resumed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isExpired() {
        Object object = this._mutex;
        synchronized (object) {
            return this._expired;
        }
    }

    public Object getObject() {
        return this._object;
    }

    public void setObject(Object object) {
        this._object = object;
    }

    public Object getMutex() {
        return this._mutex;
    }

    public void setMutex(Object mutex) {
        if (!this._new && this._mutex != this && this._pending) {
            throw new IllegalStateException();
        }
        this._mutex = mutex == null ? this : mutex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        WaitingContinuation waitingContinuation = this;
        synchronized (waitingContinuation) {
            return "WaitingContinuation@" + this.hashCode() + (this._new ? ",new" : "") + (this._pending ? ",pending" : "") + (this._resumed ? ",resumed" : "") + (this._expired ? ",expired" : "");
        }
    }
}

