/*
 * Decompiled with CFR 0.152.
 */
package org.granite.gravity.tomcat;

import java.io.IOException;
import java.io.InputStream;
import org.granite.gravity.tomcat.CometIO;

public class ByteArrayCometIO
extends InputStream
implements CometIO {
    private static final byte[] BYTES_0 = new byte[0];
    protected final int initialCapacity;
    protected byte[] buf = BYTES_0;
    protected int pos = 0;
    protected int mark = 0;
    protected int count = 0;

    public ByteArrayCometIO() {
        this(2048);
    }

    public ByteArrayCometIO(int initialCapacity) {
        if (initialCapacity < 1) {
            throw new IllegalArgumentException("initialCapacity must be > 1: " + initialCapacity);
        }
        this.initialCapacity = initialCapacity;
    }

    public int readFully(InputStream is) throws IOException {
        try {
            int b = -1;
            while ((b = is.read()) != -1) {
                if (this.count + 1 >= this.buf.length) {
                    if (this.buf.length > 0) {
                        byte[] tmp = new byte[this.buf.length << 1];
                        System.arraycopy(this.buf, 0, tmp, 0, this.buf.length);
                        this.buf = tmp;
                    } else {
                        this.buf = new byte[this.initialCapacity];
                    }
                }
                this.buf[this.count++] = (byte)b;
            }
            int n = this.count;
            return n;
        }
        finally {
            is.close();
        }
    }

    public boolean readAvailable(InputStream is) throws IOException {
        boolean eof = false;
        try {
            int available = -1;
            while ((available = is.available()) > 0) {
                if (this.count > 0) {
                    byte[] newBytes = new byte[available + this.count + 1];
                    System.arraycopy(this.buf, 0, newBytes, 0, this.count);
                    this.buf = newBytes;
                } else {
                    this.buf = new byte[available + 1];
                }
                if (is.read(this.buf, this.count, available) != available) {
                    throw new IOException("Could not read available bytes: " + available);
                }
                this.count += available;
            }
            int b = is.read();
            if (b == -1) {
                eof = true;
                return false;
            }
            this.buf[this.buf.length - 1] = (byte)b;
            ++this.count;
            return true;
        }
        finally {
            if (eof) {
                is.close();
            }
        }
    }

    public InputStream getInputStream() throws IOException {
        return this;
    }

    public int read() throws IOException {
        return this.pos < this.count ? this.buf[this.pos++] & 0xFF : -1;
    }

    public int read(byte[] b, int off, int len) {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (this.pos >= this.count) {
            return -1;
        }
        if (this.pos + len > this.count) {
            len = this.count - this.pos;
        }
        if (len <= 0) {
            return 0;
        }
        System.arraycopy(this.buf, this.pos, b, off, len);
        this.pos += len;
        return len;
    }

    public long skip(long n) {
        if ((long)this.pos + n > (long)this.count) {
            n = this.count - this.pos;
        }
        if (n < 0L) {
            return 0L;
        }
        this.pos = (int)((long)this.pos + n);
        return n;
    }

    public int available() {
        return this.count - this.pos;
    }

    public boolean markSupported() {
        return true;
    }

    public void mark(int readAheadLimit) {
        this.mark = this.pos;
    }

    public void reset() {
        this.pos = this.mark;
    }

    public void close() throws IOException {
    }
}

