/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.amf.io.convert;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.List;
import org.granite.messaging.amf.io.convert.Converter;
import org.granite.messaging.amf.io.convert.NoConverterFoundException;
import org.granite.messaging.amf.io.convert.Reverter;
import org.granite.util.ClassUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Converters {
    private final Converter[] converters;
    private final Reverter[] reverters;

    public Converters(List<Class<? extends Converter>> converterClasses) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        ArrayList<Converter> converters = new ArrayList<Converter>();
        ArrayList<Reverter> reverters = new ArrayList<Reverter>();
        if (converterClasses != null) {
            for (Class<? extends Converter> converterClass : converterClasses) {
                Constructor<? extends Converter> constructor = converterClass.getConstructor(Converters.class);
                Converter converter = constructor.newInstance(this);
                converters.add(converter);
                if (!(converter instanceof Reverter)) continue;
                reverters.add((Reverter)((Object)converter));
            }
        }
        this.converters = converters.toArray(new Converter[converters.size()]);
        this.reverters = reverters.toArray(new Reverter[reverters.size()]);
    }

    public Converter getConverter(Object value, Type targetType) {
        return this.getConverter(value, targetType, false);
    }

    public Converter getConverter(Object value, Type targetType, boolean throwNotFoundException) throws NoConverterFoundException {
        if (targetType instanceof TypeVariable) {
            targetType = ClassUtil.getBoundType((TypeVariable)targetType);
        }
        Converter[] converterArray = this.converters;
        int n = this.converters.length;
        int n2 = 0;
        while (n2 < n) {
            Converter converter = converterArray[n2];
            if (converter.canConvert(value, targetType)) {
                return converter;
            }
            ++n2;
        }
        if (!throwNotFoundException) {
            return null;
        }
        throw new NoConverterFoundException(value, targetType);
    }

    public Object convert(Object value, Type targetType) throws NoConverterFoundException {
        return this.getConverter(value, targetType, true).convert(value, targetType);
    }

    public boolean hasReverters() {
        return this.reverters.length > 0;
    }

    public Object revert(Object value) {
        Reverter[] reverterArray = this.reverters;
        int n = this.reverters.length;
        int n2 = 0;
        while (n2 < n) {
            Reverter reverter = reverterArray[n2];
            if (reverter.canRevert(value)) {
                return reverter.revert(value);
            }
            ++n2;
        }
        return value;
    }

    public Converter[] getConverters() {
        Converter[] copy = new Converter[this.converters.length];
        System.arraycopy(this.converters, 0, copy, 0, this.converters.length);
        return copy;
    }
}

