/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.amf.io.convert.impl;

import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.Collection;
import org.granite.messaging.amf.io.convert.Converter;
import org.granite.messaging.amf.io.convert.Converters;
import org.granite.messaging.amf.io.convert.IllegalConverterArgumentException;
import org.granite.util.ClassUtil;
import org.granite.util.CollectionUtil;

public class Array2Collection
extends Converter {
    public Array2Collection(Converters converters) {
        super(converters);
    }

    protected boolean internalCanConvert(Object value, Type targetType) {
        Type targetComponentType = CollectionUtil.getComponentType(targetType);
        if (targetComponentType == null) {
            return false;
        }
        if (value == null) {
            return true;
        }
        if (!value.getClass().isArray()) {
            return false;
        }
        Class<?> oComponentClass = value.getClass().getComponentType();
        if (targetComponentType.equals(oComponentClass)) {
            return true;
        }
        Converter itemConverter = null;
        int length = Array.getLength(value);
        int i = 0;
        while (i < length) {
            Object item = Array.get(value, i);
            if (itemConverter == null) {
                itemConverter = this.converters.getConverter(item, targetComponentType);
            } else if (!itemConverter.canConvert(item, targetComponentType)) {
                itemConverter = this.converters.getConverter(item, targetComponentType);
            }
            if (itemConverter == null) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected Object internalConvert(Object value, Type targetType) {
        Type targetComponentType;
        if (value == null) {
            return null;
        }
        if (value.getClass().isArray() && (targetComponentType = CollectionUtil.getComponentType(targetType)) != null) {
            int length = Array.getLength(value);
            Class<?> targetClass = ClassUtil.classOfType(targetType);
            Collection<Object> targetInstance = null;
            try {
                targetInstance = CollectionUtil.newCollection(targetClass, Array.getLength(value));
            }
            catch (Exception e) {
                throw new IllegalConverterArgumentException((Converter)this, value, targetType, e);
            }
            Converter itemConverter = null;
            int i = 0;
            while (i < length) {
                Object item = Array.get(value, i);
                if (itemConverter == null) {
                    itemConverter = this.converters.getConverter(item, targetComponentType);
                } else if (!itemConverter.canConvert(item, targetComponentType)) {
                    itemConverter = this.converters.getConverter(item, targetComponentType);
                }
                if (itemConverter == null) {
                    throw new IllegalConverterArgumentException(this, value, targetType);
                }
                targetInstance.add(itemConverter.convert(item, targetComponentType));
                ++i;
            }
            return targetInstance;
        }
        throw new IllegalConverterArgumentException(this, value, targetType);
    }
}

