/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.service;

import flex.messaging.messages.RemotingMessage;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.granite.config.flex.Destination;
import org.granite.config.flex.Factory;
import org.granite.context.GraniteContext;
import org.granite.logging.Logger;
import org.granite.messaging.service.DefaultServiceExceptionHandler;
import org.granite.messaging.service.ServiceException;
import org.granite.messaging.service.ServiceExceptionHandler;
import org.granite.messaging.service.ServiceInvoker;
import org.granite.util.ClassUtil;
import org.granite.util.XMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ServiceFactory
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(ServiceFactory.class);
    private static final ReentrantLock lock = new ReentrantLock();
    private ServiceExceptionHandler serviceExceptionHandler;

    public static ServiceFactory getFactoryInstance(RemotingMessage request) throws ServiceException {
        GraniteContext context = GraniteContext.getCurrentInstance();
        String messageType = request.getClass().getName();
        String destinationId = request.getDestination();
        log.debug(">> Finding factoryId for messageType: %s and destinationId: %s", messageType, destinationId);
        Destination destination = context.getServicesConfig().findDestinationById(messageType, destinationId);
        if (destination == null) {
            throw new ServiceException("Destination not found: " + destinationId);
        }
        String factoryId = destination.getProperties().get("factory");
        log.debug(">> Found factoryId: %s", factoryId);
        Map<String, Object> cache = context.getApplicationMap();
        String key = String.valueOf(ServiceFactory.class.getName()) + '.' + factoryId;
        return ServiceFactory.getServiceFactory(cache, context, factoryId, key);
    }

    private static ServiceFactory getServiceFactory(Map<String, Object> cache, GraniteContext context, String factoryId, String key) {
        lock.lock();
        try {
            ServiceFactory factory = (ServiceFactory)cache.get(key);
            if (factory == null) {
                log.debug(">> No cached factory for: %s", factoryId);
                Factory config = context.getServicesConfig().findFactoryById(factoryId);
                if (config == null) {
                    config = ServiceFactory.getDefaultFactoryConfig();
                }
                try {
                    Class<ServiceFactory> clazz = ClassUtil.forName(config.getClassName(), ServiceFactory.class);
                    factory = clazz.newInstance();
                    factory.configure(config.getProperties());
                }
                catch (Exception e) {
                    throw new ServiceException("Could not instantiate factory: " + factory, e);
                }
                cache.put(key, factory);
            } else {
                log.debug(">> Found a cached factory for: %s", factoryId);
            }
            log.debug("<< Returning factory: %s", factory);
            ServiceFactory serviceFactory = factory;
            return serviceFactory;
        }
        finally {
            lock.unlock();
        }
    }

    private static Factory getDefaultFactoryConfig() {
        return Factory.DEFAULT_FACTORY;
    }

    public void configure(XMap properties) throws ServiceException {
        log.debug(">> Configuring factory with: %s", properties);
        String sServiceExceptionHandler = properties.get("service-exception-handler");
        String enableLogging = properties.get("enable-exception-logging");
        if (sServiceExceptionHandler != null) {
            try {
                if (Boolean.TRUE.toString().equals(enableLogging) || Boolean.FALSE.toString().equals(enableLogging)) {
                    this.serviceExceptionHandler = (ServiceExceptionHandler)ClassUtil.newInstance(sServiceExceptionHandler.trim(), new Class[]{Boolean.TYPE}, new Object[]{Boolean.valueOf(enableLogging)});
                }
                this.serviceExceptionHandler = (ServiceExceptionHandler)ClassUtil.newInstance(sServiceExceptionHandler.trim());
            }
            catch (Exception e) {
                throw new ServiceException("Could not instantiate service exception handler: " + sServiceExceptionHandler, e);
            }
        } else {
            this.serviceExceptionHandler = Boolean.TRUE.toString().equals(enableLogging) || Boolean.FALSE.toString().equals(enableLogging) ? new DefaultServiceExceptionHandler(Boolean.valueOf(enableLogging)) : new DefaultServiceExceptionHandler();
        }
        log.debug("<< Configuring factory done: %s", this);
    }

    public abstract ServiceInvoker<?> getServiceInstance(RemotingMessage var1) throws ServiceException;

    public ServiceExceptionHandler getServiceExceptionHandler() {
        return this.serviceExceptionHandler;
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(String append) {
        return String.valueOf(super.toString()) + " {" + (append != null ? append : "") + "\n  serviceExceptionHandler: " + this.serviceExceptionHandler + "\n}";
    }
}

