/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.webapp;

import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.granite.config.GraniteConfig;
import org.granite.config.flex.ServicesConfig;
import org.granite.context.GraniteContext;
import org.granite.messaging.webapp.ApplicationMap;
import org.granite.messaging.webapp.InitialisationMap;
import org.granite.messaging.webapp.RequestMap;
import org.granite.messaging.webapp.SessionMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpGraniteContext
extends GraniteContext {
    private static final String SESSION_LOCK_KEY = String.valueOf(HttpGraniteContext.class.getName()) + ".LOCK";
    private final ServletContext context;
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private InitialisationMap initialisationMap = null;
    private ApplicationMap applicationMap = null;
    private SessionMap sessionMap = null;
    private RequestMap requestMap = null;

    public static HttpGraniteContext createThreadIntance(GraniteConfig graniteConfig, ServicesConfig servicesConfig, ServletContext context, HttpServletRequest request, HttpServletResponse response) {
        HttpGraniteContext graniteContext = new HttpGraniteContext(graniteConfig, servicesConfig, context, request, response);
        HttpGraniteContext.setCurrentInstance(graniteContext);
        return graniteContext;
    }

    private HttpGraniteContext(GraniteConfig graniteConfig, ServicesConfig servicesConfig, ServletContext context, HttpServletRequest request, HttpServletResponse response) {
        super(graniteConfig, servicesConfig);
        this.context = context;
        this.request = request;
        this.response = response;
    }

    public ServletContext getServletContext() {
        return this.context;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public HttpSession getSession(boolean create) {
        return this.request.getSession(create);
    }

    public HttpSession getSession() {
        return this.request.getSession(true);
    }

    @Override
    public synchronized Object getSessionLock() {
        Object lock = this.request.getSession(true).getAttribute(SESSION_LOCK_KEY);
        if (lock == null) {
            lock = new Boolean(true);
            this.request.getSession(true).setAttribute(SESSION_LOCK_KEY, lock);
        }
        return lock;
    }

    @Override
    public Map<String, String> getInitialisationMap() {
        if (this.initialisationMap == null) {
            this.initialisationMap = new InitialisationMap(this.context);
        }
        return this.initialisationMap;
    }

    @Override
    public Map<String, Object> getApplicationMap() {
        if (this.applicationMap == null) {
            this.applicationMap = new ApplicationMap(this.context);
        }
        return this.applicationMap;
    }

    @Override
    public Map<String, Object> getSessionMap() {
        return this.getSessionMap(true);
    }

    @Override
    public Map<String, Object> getSessionMap(boolean create) {
        if (this.sessionMap == null && (create || this.request.getSession(false) != null)) {
            this.sessionMap = new SessionMap(this.request);
        }
        return this.sessionMap;
    }

    @Override
    public Map<String, Object> getRequestMap() {
        if (this.requestMap == null) {
            this.requestMap = new RequestMap(this.request);
        }
        return this.requestMap;
    }
}

