/*
 * Decompiled with CFR 0.152.
 */
package org.granite.osgi.adaptor;

import java.util.Iterator;
import java.util.Set;
import org.granite.config.flex.ServicesConfig;
import org.granite.logging.Logger;
import org.granite.osgi.constants.OSGIConstants;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class ServiceEventHandler
implements EventHandler {
    private static final Logger log = Logger.getLogger(ServiceEventHandler.class);
    private ServicesConfig servicesConfig;

    public ServiceEventHandler(ServicesConfig servicesConfig) {
        this.servicesConfig = servicesConfig;
    }

    public void handleEvent(Event event) {
        Iterator it;
        Class c = (Class)event.getProperty("serviceClass");
        Set classes = (Set)event.getProperty("serviceClassSet");
        if (event.getTopic().equals(OSGIConstants.TOPIC_GDS_ADD_SERVICE)) {
            if (c != null) {
                this.servicesConfig.handleClass(c);
            }
            if (classes != null) {
                it = classes.iterator();
                while (it.hasNext()) {
                    this.servicesConfig.handleClass((Class)it.next());
                }
            } else {
                log.warn("Class NOT Found!!", new Object[0]);
            }
        }
        if (event.getTopic().equals(OSGIConstants.TOPIC_GDS_REMOVE_SERVICE)) {
            if (c != null) {
                this.servicesConfig.handleRemoveService(c);
            }
            if (classes != null) {
                it = classes.iterator();
                while (it.hasNext()) {
                    this.servicesConfig.handleRemoveService((Class)it.next());
                }
            } else {
                log.warn("Class NOT Found!!", new Object[0]);
            }
        }
    }
}

