/*
 * Decompiled with CFR 0.152.
 */
package org.granite.tide.ejb;

import flex.messaging.messages.RemotingMessage;
import java.util.Map;
import org.granite.config.flex.Destination;
import org.granite.context.GraniteContext;
import org.granite.messaging.service.ExtendedServiceExceptionHandler;
import org.granite.messaging.service.ServiceException;
import org.granite.messaging.service.ServiceFactory;
import org.granite.messaging.service.ServiceInvoker;
import org.granite.scan.ScannedItemHandler;
import org.granite.tide.TideServiceInvoker;
import org.granite.tide.data.PersistenceExceptionConverter;
import org.granite.tide.ejb.EJBAccessExceptionConverter;
import org.granite.tide.ejb.EjbScannedItemHandler;
import org.granite.tide.ejb.EjbServiceContext;
import org.granite.util.XMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EjbServiceFactory
extends ServiceFactory {
    private static final long serialVersionUID = 1L;
    public static final String ENTITY_MANAGER_FACTORY_JNDI_NAME = "entity-manager-factory-jndi-name";
    public static final String ENTITY_MANAGER_JNDI_NAME = "entity-manager-jndi-name";
    private String lookup = null;

    public static ScannedItemHandler getScannedItemHandler() {
        return EjbScannedItemHandler.instance(true);
    }

    public String getLookup() {
        return this.lookup;
    }

    @Override
    public void configure(XMap properties) throws ServiceException {
        String sServiceExceptionHandler = properties.get("service-exception-handler");
        if (sServiceExceptionHandler == null) {
            XMap props = new XMap(properties);
            props.put("service-exception-handler", ExtendedServiceExceptionHandler.class.getName());
            super.configure(props);
        } else {
            super.configure(properties);
        }
        GraniteContext graniteContext = GraniteContext.getCurrentInstance();
        graniteContext.getGraniteConfig().registerExceptionConverter(PersistenceExceptionConverter.class);
        graniteContext.getGraniteConfig().registerExceptionConverter(EJBAccessExceptionConverter.class);
        this.lookup = properties.get("lookup");
    }

    @Override
    public ServiceInvoker<?> getServiceInstance(RemotingMessage request) throws ServiceException {
        String messageType = request.getClass().getName();
        String destinationId = request.getDestination();
        GraniteContext context = GraniteContext.getCurrentInstance();
        Map<String, Object> cache = context.getSessionMap();
        Destination destination = context.getServicesConfig().findDestinationById(messageType, destinationId);
        String key = String.valueOf(TideServiceInvoker.class.getName()) + '.' + destinationId;
        return this.getServiceInvoker(cache, destination, key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceInvoker<?> getServiceInvoker(Map<String, Object> cache, Destination destination, String key) {
        GraniteContext context = GraniteContext.getCurrentInstance();
        Object object = context.getSessionLock();
        synchronized (object) {
            TideServiceInvoker<EjbServiceFactory> invoker = (TideServiceInvoker<EjbServiceFactory>)cache.get(key);
            if (invoker == null) {
                String lookup = this.getLookup();
                if (destination.getProperties().containsKey("lookup")) {
                    lookup = destination.getProperties().get("lookup");
                }
                EjbServiceContext tideContext = new EjbServiceContext(lookup);
                if (destination.getProperties().containsKey(ENTITY_MANAGER_FACTORY_JNDI_NAME)) {
                    tideContext.setEntityManagerFactoryJndiName(destination.getProperties().get(ENTITY_MANAGER_FACTORY_JNDI_NAME));
                } else if (destination.getProperties().containsKey(ENTITY_MANAGER_JNDI_NAME)) {
                    tideContext.setEntityManagerJndiName(destination.getProperties().get(ENTITY_MANAGER_JNDI_NAME));
                }
                invoker = new TideServiceInvoker<EjbServiceFactory>(destination, this, tideContext);
                cache.put(key, invoker);
            }
            return invoker;
        }
    }
}

