/*
 * Decompiled with CFR 0.152.
 */
package org.granite.gravity.gae;

import com.google.appengine.api.memcache.Expiration;
import com.google.appengine.api.memcache.MemcacheService;
import com.google.appengine.api.memcache.MemcacheServiceFactory;
import flex.messaging.messages.Message;
import org.granite.config.GraniteConfig;
import org.granite.config.flex.ServicesConfig;
import org.granite.gravity.Channel;
import org.granite.gravity.DefaultGravity;
import org.granite.gravity.GravityConfig;
import org.granite.gravity.Subscription;
import org.granite.util.UUIDUtil;

public class GAEGravity
extends DefaultGravity {
    static final String CHANNEL_PREFIX = "org.granite.gravity.gae.channel.";
    private static MemcacheService gaeCache = MemcacheServiceFactory.getMemcacheService();

    public GAEGravity(GravityConfig gravityConfig, ServicesConfig servicesConfig, GraniteConfig graniteConfig) {
        super(gravityConfig, servicesConfig, graniteConfig);
    }

    protected Channel createChannel() {
        Channel channel = this.getGravityConfig().getChannelFactory().newChannel(UUIDUtil.randomUUID());
        Expiration expiration = Expiration.byDeltaMillis((int)((int)this.getGravityConfig().getChannelIdleTimeoutMillis()));
        gaeCache.put((Object)(CHANNEL_PREFIX + channel.getId()), (Object)channel, expiration);
        gaeCache.put((Object)("org.granite.gravity.channel.msgCount." + channel.getId()), (Object)0L, expiration);
        return channel;
    }

    public Channel getChannel(String channelId) {
        if (channelId == null) {
            return null;
        }
        return (Channel)gaeCache.get((Object)(CHANNEL_PREFIX + channelId));
    }

    public Channel removeChannel(String channelId) {
        if (channelId == null) {
            return null;
        }
        Channel channel = (Channel)gaeCache.get((Object)(CHANNEL_PREFIX + channelId));
        if (channel != null) {
            for (Subscription subscription : channel.getSubscriptions()) {
                Message message = subscription.getUnsubscribeMessage();
                this.handleMessage(message, true);
            }
            channel.destroy();
            gaeCache.delete((Object)(CHANNEL_PREFIX + channelId));
            gaeCache.delete((Object)("org.granite.gravity.channel.msgCount." + channelId));
        }
        return channel;
    }

    public boolean access(String channelId) {
        return true;
    }

    public void internalStart() {
    }

    protected void postManage(Channel channel) {
        Expiration expiration = Expiration.byDeltaMillis((int)((int)this.getGravityConfig().getChannelIdleTimeoutMillis()));
        gaeCache.put((Object)(CHANNEL_PREFIX + channel.getId()), (Object)channel, expiration);
    }
}

