/*
 * Decompiled with CFR 0.152.
 */
package org.granite.gravity.weblogic;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.ServletConfig;
import org.granite.gravity.AbstractChannel;
import org.granite.gravity.AsyncHttpContext;
import org.granite.gravity.GravityConfig;
import org.granite.logging.Logger;
import weblogic.servlet.http.AbstractAsyncServlet;
import weblogic.servlet.http.RequestResponseKey;

public class WebLogicChannel
extends AbstractChannel {
    private static final Logger log = Logger.getLogger(WebLogicChannel.class);
    private static Method isValid = null;
    private final AtomicReference<RequestResponseKey> key = new AtomicReference();

    static {
        try {
            isValid = RequestResponseKey.class.getDeclaredMethod("isValid", new Class[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public WebLogicChannel(ServletConfig servletConfig, GravityConfig gravityConfig, String id) {
        super(servletConfig, gravityConfig, id);
    }

    public void setRequestResponseKey(RequestResponseKey key) {
        RequestResponseKey previousKey;
        if (log.isDebugEnabled()) {
            log.debug("Channel: %s got new asyncContext: %s", this.getId(), key);
        }
        if ((previousKey = this.key.getAndSet(key)) != null) {
            if (key != null) {
                log.warn("Got a new non null key %s while current key %s isn't null", key, this.key.get());
            }
            if (previousKey != key) {
                try {
                    previousKey.getResponse().getOutputStream().close();
                }
                catch (Exception e) {
                    log.debug(e, "Error while closing key", new Object[0]);
                }
            }
        }
        if (key != null) {
            this.queueReceiver();
        }
    }

    protected boolean hasAsyncHttpContext() {
        return this.key.get() != null;
    }

    protected AsyncHttpContext acquireAsyncHttpContext() {
        RequestResponseKey key = this.key.getAndSet(null);
        if (key == null || !WebLogicChannel.isValid(key)) {
            return null;
        }
        try {
            AbstractAsyncServlet.notify((RequestResponseKey)key, (Object)this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    protected void releaseAsyncHttpContext(AsyncHttpContext context) {
        try {
            if (context != null) {
                context.getResponse().getOutputStream().close();
            }
        }
        catch (Exception e) {
            log.warn(e, "Could not release asyncHttpContext for channel: %s", this);
        }
    }

    public void destroy() {
        try {
            super.destroy();
        }
        catch (Throwable throwable) {
            RequestResponseKey key = this.key.getAndSet(null);
            if (key != null) {
                try {
                    key.getResponse().getOutputStream().close();
                }
                catch (Exception e) {
                    log.debug(e, "Could not close key: %s for channel: %s", key, this);
                }
            }
            throw throwable;
        }
        RequestResponseKey key = this.key.getAndSet(null);
        if (key != null) {
            try {
                key.getResponse().getOutputStream().close();
            }
            catch (Exception e) {
                log.debug(e, "Could not close key: %s for channel: %s", key, this);
            }
        }
    }

    private static boolean isValid(RequestResponseKey key) {
        if (isValid != null) {
            try {
                return (Boolean)isValid.invoke((Object)key, new Object[0]);
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }
}

